/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.gdl.functions;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.io.impl.gdl.GDLEncoder;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class GraphTransactionsToGDL
implements GroupReduceFunction<GraphTransaction, String> {
    public void reduce(Iterable<GraphTransaction> graphTransactions, Collector<String> out) throws Exception {
        ArrayList<EPGMGraphHead> graphHeads = new ArrayList<EPGMGraphHead>();
        ArrayList<EPGMVertex> vertices = new ArrayList<EPGMVertex>();
        ArrayList<EPGMEdge> edges = new ArrayList<EPGMEdge>();
        for (GraphTransaction gt : graphTransactions) {
            graphHeads.add(gt.getGraphHead());
            vertices.addAll(gt.getVertices());
            edges.addAll(gt.getEdges());
        }
        GDLEncoder encoder = new GDLEncoder(graphHeads, vertices, edges);
        String result = encoder.getGDLString();
        out.collect((Object)result);
    }
}

