/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.graph;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.gradoop.flink.io.api.DataSource;
import org.gradoop.flink.io.impl.graph.functions.InitEdge;
import org.gradoop.flink.io.impl.graph.functions.InitVertex;
import org.gradoop.flink.io.impl.graph.functions.UpdateEdge;
import org.gradoop.flink.io.impl.graph.tuples.ImportEdge;
import org.gradoop.flink.io.impl.graph.tuples.ImportVertex;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.epgm.LogicalGraphFactory;
import org.gradoop.flink.model.impl.functions.tuple.Project3To0And1;
import org.gradoop.flink.model.impl.functions.tuple.Value2Of3;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class GraphDataSource<K extends Comparable<K>>
implements DataSource {
    private final DataSet<ImportVertex<K>> importVertices;
    private final DataSet<ImportEdge<K>> importEdges;
    private final String lineagePropertyKey;
    private final GradoopFlinkConfig config;

    public GraphDataSource(DataSet<ImportVertex<K>> importVertices, DataSet<ImportEdge<K>> importEdges, GradoopFlinkConfig config) {
        this(importVertices, importEdges, null, config);
    }

    public GraphDataSource(DataSet<ImportVertex<K>> importVertices, DataSet<ImportEdge<K>> importEdges, String lineagePropertyKey, GradoopFlinkConfig config) {
        this.importVertices = (DataSet)Preconditions.checkNotNull(importVertices);
        this.importEdges = (DataSet)Preconditions.checkNotNull(importEdges);
        this.lineagePropertyKey = lineagePropertyKey;
        this.config = (GradoopFlinkConfig)((Object)Preconditions.checkNotNull((Object)((Object)config)));
    }

    @Override
    public LogicalGraph getLogicalGraph() {
        TypeInformation externalIdType = ((TupleTypeInfo)this.importVertices.getType()).getTypeAt(0);
        LogicalGraphFactory factory = this.config.getLogicalGraphFactory();
        MapOperator vertexTriples = this.importVertices.map(new InitVertex(factory.getVertexFactory(), this.lineagePropertyKey, externalIdType));
        MapOperator epgmVertices = vertexTriples.map(new Value2Of3());
        MapOperator vertexIdPair = vertexTriples.map(new Project3To0And1());
        JoinOperator.EquiJoin epgmEdges = this.importEdges.join((DataSet)vertexIdPair).where(new int[]{1}).equalTo(new int[]{0}).with(new InitEdge(factory.getEdgeFactory(), this.lineagePropertyKey, externalIdType)).join((DataSet)vertexIdPair).where(new int[]{0}).equalTo(new int[]{0}).with(new UpdateEdge());
        return factory.fromDataSets((DataSet)epgmVertices, (DataSet)epgmEdges);
    }

    @Override
    public GraphCollection getGraphCollection() throws IOException {
        LogicalGraph logicalGraph = this.getLogicalGraph();
        return logicalGraph.getCollectionFactory().fromGraph(logicalGraph);
    }
}

