/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.graph.functions;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.io.impl.graph.functions.InitElement;
import org.gradoop.flink.io.impl.graph.tuples.ImportEdge;

@FunctionAnnotation.ForwardedFieldsFirst(value={"f2->f0;f3->f1.label;f4->f1.properties"})
@FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f1.sourceId"})
public class InitEdge<K extends Comparable<K>>
extends InitElement<EPGMEdge, K>
implements JoinFunction<ImportEdge<K>, Tuple2<K, GradoopId>, Tuple2<K, EPGMEdge>>,
ResultTypeQueryable<Tuple2<K, EPGMEdge>> {
    private final EdgeFactory<EPGMEdge> edgeFactory;
    private final Tuple2<K, EPGMEdge> reuseTuple;

    public InitEdge(EdgeFactory<EPGMEdge> epgmEdgeFactory, String lineagePropertyKey, TypeInformation<K> keyTypeInfo) {
        super(lineagePropertyKey, keyTypeInfo);
        this.edgeFactory = epgmEdgeFactory;
        this.reuseTuple = new Tuple2();
    }

    public Tuple2<K, EPGMEdge> join(ImportEdge<K> importEdge, Tuple2<K, GradoopId> vertexIdPair) throws Exception {
        this.reuseTuple.f0 = importEdge.getTargetId();
        EPGMEdge edge = (EPGMEdge)this.edgeFactory.createEdge(importEdge.getLabel(), (GradoopId)vertexIdPair.f1, GradoopId.get(), importEdge.getProperties());
        this.reuseTuple.f1 = this.updateLineage(edge, importEdge.getId());
        return this.reuseTuple;
    }

    public TypeInformation<Tuple2<K, EPGMEdge>> getProducedType() {
        return new TupleTypeInfo(new TypeInformation[]{this.getKeyTypeInfo(), TypeExtractor.createTypeInfo((Class)this.edgeFactory.getType())});
    }
}

