/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.graph.functions;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.gradoop.common.model.impl.pojo.EPGMElement;

public abstract class InitElement<EL extends EPGMElement, K extends Comparable<K>>
implements Serializable {
    private final boolean keepLineage;
    private final String lineagePropertyKey;
    private final TypeInformation<K> keyTypeInfo;

    public InitElement(String lineagePropertyKey, TypeInformation<K> keyTypeInfo) {
        this.keepLineage = lineagePropertyKey != null;
        this.lineagePropertyKey = lineagePropertyKey;
        this.keyTypeInfo = (TypeInformation)Preconditions.checkNotNull(keyTypeInfo, (Object)"key type was null");
    }

    protected EL updateLineage(EL element, K importKey) {
        if (this.keepLineage) {
            element.setProperty(this.lineagePropertyKey, importKey);
        }
        return element;
    }

    protected TypeInformation<K> getKeyTypeInfo() {
        return this.keyTypeInfo;
    }
}

