/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.graph.functions;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.io.impl.graph.functions.InitElement;
import org.gradoop.flink.io.impl.graph.tuples.ImportVertex;

@FunctionAnnotation.ForwardedFields(value={"f0;f1->f2.label;f2->f2.properties"})
public class InitVertex<K extends Comparable<K>>
extends InitElement<EPGMVertex, K>
implements MapFunction<ImportVertex<K>, Tuple3<K, GradoopId, EPGMVertex>>,
ResultTypeQueryable<Tuple3<K, GradoopId, EPGMVertex>> {
    private final VertexFactory<EPGMVertex> vertexFactory;
    private final Tuple3<K, GradoopId, EPGMVertex> reuseTuple;

    public InitVertex(VertexFactory<EPGMVertex> epgmVertexFactory, String lineagePropertyKey, TypeInformation<K> externalIdType) {
        super(lineagePropertyKey, externalIdType);
        this.vertexFactory = epgmVertexFactory;
        this.reuseTuple = new Tuple3();
    }

    public Tuple3<K, GradoopId, EPGMVertex> map(ImportVertex<K> importVertex) throws Exception {
        this.reuseTuple.f0 = importVertex.getId();
        EPGMVertex vertex = (EPGMVertex)this.vertexFactory.createVertex(importVertex.getLabel(), importVertex.getProperties());
        this.reuseTuple.f1 = vertex.getId();
        this.reuseTuple.f2 = this.updateLineage(vertex, importVertex.getId());
        return this.reuseTuple;
    }

    public TypeInformation<Tuple3<K, GradoopId, EPGMVertex>> getProducedType() {
        return new TupleTypeInfo(new TypeInformation[]{this.getKeyTypeInfo(), TypeExtractor.getForClass(GradoopId.class), TypeExtractor.createTypeInfo((Class)this.vertexFactory.getType())});
    }
}

