/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.statistics;

import java.io.IOException;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.statistics.DistinctEdgeProperties;
import org.gradoop.flink.model.impl.operators.statistics.DistinctSourceIdsByEdgeLabel;
import org.gradoop.flink.model.impl.operators.statistics.DistinctTargetIdsByEdgeLabel;
import org.gradoop.flink.model.impl.operators.statistics.DistinctVertexProperties;
import org.gradoop.flink.model.impl.operators.statistics.EdgeLabelDistribution;
import org.gradoop.flink.model.impl.operators.statistics.IncomingVertexDegreeDistribution;
import org.gradoop.flink.model.impl.operators.statistics.OutgoingVertexDegreeDistribution;
import org.gradoop.flink.model.impl.operators.statistics.VertexDegreeDistribution;
import org.gradoop.flink.model.impl.operators.statistics.VertexLabelDistribution;
import org.gradoop.flink.model.impl.operators.statistics.writer.DistinctEdgePropertiesByLabelPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.DistinctSourceVertexCountPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.DistinctTargetVertexCountPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.DistinctVertexPropertiesByLabelPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.EdgeCountPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.SourceAndEdgeLabelDistributionPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.StatisticWriter;
import org.gradoop.flink.model.impl.operators.statistics.writer.TargetAndEdgeLabelDistributionPreparer;
import org.gradoop.flink.model.impl.operators.statistics.writer.VertexCountPreparer;

public class GraphStatisticsDataSink
implements DataSink {
    private final String path;

    public GraphStatisticsDataSink(String path) {
        this.path = path;
    }

    @Override
    public void write(LogicalGraph logicalGraph) throws IOException {
        this.write(logicalGraph, false);
    }

    @Override
    public void write(LogicalGraph logicalGraph, boolean overwrite) throws IOException {
        StatisticWriter.writeCSV(new DistinctEdgePropertiesByLabelPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_edge_properties_by_label", overwrite);
        StatisticWriter.writeCSV(new DistinctEdgeProperties().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_edge_properties", overwrite);
        StatisticWriter.writeCSV(new DistinctSourceIdsByEdgeLabel().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_source_vertex_count_by_edge_label", overwrite);
        StatisticWriter.writeCSV(new DistinctSourceVertexCountPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_source_vertex_count", overwrite);
        StatisticWriter.writeCSV(new DistinctTargetVertexCountPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_target_vertex_count", overwrite);
        StatisticWriter.writeCSV(new DistinctTargetIdsByEdgeLabel().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_target_vertex_count_by_edge_label", overwrite);
        StatisticWriter.writeCSV(new DistinctVertexProperties().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_vertex_properties", overwrite);
        StatisticWriter.writeCSV(new DistinctVertexPropertiesByLabelPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "distinct_vertex_properties_by_label", overwrite);
        StatisticWriter.writeCSV(new EdgeCountPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "edge_count", overwrite);
        StatisticWriter.writeCSV(new EdgeLabelDistribution().execute(logicalGraph), this.appendSeparator(this.path) + "edge_count_by_label", overwrite);
        StatisticWriter.writeCSV(new SourceAndEdgeLabelDistributionPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "edge_count_by_source_vertex_and_edge_label", overwrite);
        StatisticWriter.writeCSV(new TargetAndEdgeLabelDistributionPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "edge_count_by_target_vertex_and_edge_label", overwrite);
        StatisticWriter.writeCSV(new VertexCountPreparer().execute(logicalGraph), this.appendSeparator(this.path) + "vertex_count", overwrite);
        StatisticWriter.writeCSV(new VertexDegreeDistribution().execute(logicalGraph), this.appendSeparator(this.path) + "vertex_degree_distribution", overwrite);
        StatisticWriter.writeCSV(new VertexLabelDistribution().execute(logicalGraph), this.appendSeparator(this.path) + "vertex_count_by_label", overwrite);
        StatisticWriter.writeCSV(new IncomingVertexDegreeDistribution().execute(logicalGraph), this.appendSeparator(this.path) + "incoming_vertex_degree_distribution", overwrite);
        StatisticWriter.writeCSV(new OutgoingVertexDegreeDistribution().execute(logicalGraph), this.appendSeparator(this.path) + "outgoing_vertex_degree_distribution", overwrite);
    }

    @Override
    public void write(GraphCollection graphCollection) throws IOException {
        this.write(graphCollection, false);
    }

    @Override
    public void write(GraphCollection graphCollection, boolean overWrite) throws IOException {
        throw new UnsupportedOperationException("This sink can only process instances of LogicalGraph");
    }

    private String appendSeparator(String directory) {
        String fileSeparator = System.getProperty("file.separator");
        String result = directory;
        if (!directory.endsWith(fileSeparator)) {
            result = directory + fileSeparator;
        }
        return result;
    }
}

