/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf;

import java.util.Map;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.util.GradoopFlinkConfig;

abstract class TLFBase {
    private final GradoopFlinkConfig config;
    private final String tlfPath;
    private final String tlfVertexDictionaryPath;
    private final String tlfEdgeDictionaryPath;
    private DataSet<Map<Integer, String>> vertexDictionary;
    private DataSet<Map<Integer, String>> edgeDictionary;

    TLFBase(String tlfPath, String tlfVertexDictionaryPath, String tlfEdgeDictionaryPath, GradoopFlinkConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (tlfPath == null) {
            throw new IllegalArgumentException("vertex file must not be null");
        }
        this.tlfPath = tlfPath;
        this.tlfVertexDictionaryPath = tlfVertexDictionaryPath;
        this.tlfEdgeDictionaryPath = tlfEdgeDictionaryPath;
        this.config = config;
    }

    public GradoopFlinkConfig getConfig() {
        return this.config;
    }

    public String getTLFPath() {
        return this.tlfPath;
    }

    public String getTLFVertexDictionaryPath() {
        return this.tlfVertexDictionaryPath;
    }

    public String getTLFEdgeDictionaryPath() {
        return this.tlfEdgeDictionaryPath;
    }

    public boolean hasVertexDictionary() {
        return !this.tlfVertexDictionaryPath.equals("");
    }

    public boolean hasEdgeDictionary() {
        return !this.tlfEdgeDictionaryPath.equals("");
    }

    public DataSet<Map<Integer, String>> getVertexDictionary() {
        return this.vertexDictionary;
    }

    public void setVertexDictionary(DataSet<Map<Integer, String>> vertexDictionary) {
        this.vertexDictionary = vertexDictionary;
    }

    public DataSet<Map<Integer, String>> getEdgeDictionary() {
        return this.edgeDictionary;
    }

    public void setEdgeDictionary(DataSet<Map<Integer, String>> edgeDictionary) {
        this.edgeDictionary = edgeDictionary;
    }
}

