/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf;

import java.io.IOException;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.core.fs.FileSystem;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.io.impl.tlf.TLFBase;
import org.gradoop.flink.io.impl.tlf.functions.EdgeLabelList;
import org.gradoop.flink.io.impl.tlf.functions.ElementLabelEncoder;
import org.gradoop.flink.io.impl.tlf.functions.TLFDictionaryFileFormat;
import org.gradoop.flink.io.impl.tlf.functions.TLFDictionaryMapGroupReducer;
import org.gradoop.flink.io.impl.tlf.functions.TLFFileFormat;
import org.gradoop.flink.io.impl.tlf.functions.VertexLabelList;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class TLFDataSink
extends TLFBase
implements DataSink {
    public TLFDataSink(String tlfPath, GradoopFlinkConfig config) {
        super(tlfPath, "", "", config);
    }

    public TLFDataSink(String tlfPath, String tlfVertexDictionaryPath, String tlfEdgeDictionaryPath, GradoopFlinkConfig config) {
        super(tlfPath, tlfVertexDictionaryPath, tlfEdgeDictionaryPath, config);
    }

    @Override
    public void write(LogicalGraph logicalGraph) throws IOException {
        this.write(logicalGraph, false);
    }

    @Override
    public void write(GraphCollection graphCollection) throws IOException {
        this.write(graphCollection, false);
    }

    @Override
    public void write(LogicalGraph logicalGraph, boolean overwrite) throws IOException {
        this.write(logicalGraph.getCollectionFactory().fromGraph(logicalGraph), overwrite);
    }

    @Override
    public void write(GraphCollection graphCollection, boolean overWrite) throws IOException {
        FileSystem.WriteMode writeMode = overWrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        DataSet<GraphTransaction> graphTransactions = graphCollection.getGraphTransactions();
        GroupReduceOperator vertexDictionary = null;
        GroupReduceOperator edgeDictionary = null;
        if (this.hasVertexDictionary()) {
            vertexDictionary = graphTransactions.flatMap((FlatMapFunction)new VertexLabelList()).distinct().reduceGroup((GroupReduceFunction)new TLFDictionaryMapGroupReducer());
            vertexDictionary.writeAsFormattedText(this.getTLFVertexDictionaryPath(), writeMode, (TextOutputFormat.TextFormatter)new TLFDictionaryFileFormat());
        }
        if (this.hasEdgeDictionary()) {
            edgeDictionary = graphTransactions.flatMap((FlatMapFunction)new EdgeLabelList()).distinct().reduceGroup((GroupReduceFunction)new TLFDictionaryMapGroupReducer());
            edgeDictionary.writeAsFormattedText(this.getTLFEdgeDictionaryPath(), writeMode, (TextOutputFormat.TextFormatter)new TLFDictionaryFileFormat());
        }
        if (this.hasVertexDictionary() || this.hasEdgeDictionary()) {
            SingleInputUdfOperator simpleLabelTransaction = this.hasVertexDictionary() && this.hasEdgeDictionary() ? ((MapOperator)graphTransactions.map((MapFunction)new ElementLabelEncoder(this.hasVertexDictionary(), this.hasEdgeDictionary())).withBroadcastSet((DataSet)vertexDictionary, "vertexDictionary")).withBroadcastSet((DataSet)edgeDictionary, "edgeDictionary") : (this.hasVertexDictionary() ? graphTransactions.map((MapFunction)new ElementLabelEncoder(this.hasVertexDictionary(), this.hasEdgeDictionary())).withBroadcastSet((DataSet)vertexDictionary, "vertexDictionary") : graphTransactions.map((MapFunction)new ElementLabelEncoder(this.hasVertexDictionary(), this.hasEdgeDictionary())).withBroadcastSet((DataSet)edgeDictionary, "edgeDictionary"));
            simpleLabelTransaction.writeAsFormattedText(this.getTLFPath(), writeMode, (TextOutputFormat.TextFormatter)new TLFFileFormat());
        } else {
            graphTransactions.writeAsFormattedText(this.getTLFPath(), writeMode, (TextOutputFormat.TextFormatter)new TLFFileFormat());
        }
    }
}

