/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.hadoopcompatibility.HadoopInputs;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.gradoop.flink.io.impl.tlf.TLFBase;
import org.gradoop.flink.io.impl.tlf.functions.Dictionary;
import org.gradoop.flink.io.impl.tlf.functions.DictionaryEntry;
import org.gradoop.flink.io.impl.tlf.functions.EdgeLabelDecoder;
import org.gradoop.flink.io.impl.tlf.functions.GraphTransactionFromText;
import org.gradoop.flink.io.impl.tlf.functions.VertexLabelDecoder;
import org.gradoop.flink.io.impl.tlf.inputformats.TLFInputFormat;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.combination.ReduceCombination;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class TLFDataSource
extends TLFBase
implements org.gradoop.flink.io.api.DataSource {
    public TLFDataSource(String tlfPath, GradoopFlinkConfig config) {
        super(tlfPath, "", "", config);
    }

    public TLFDataSource(String tlfPath, String tlfVertexDictionaryPath, String tlfEdgeDictionaryPath, GradoopFlinkConfig config) {
        super(tlfPath, tlfVertexDictionaryPath, tlfEdgeDictionaryPath, config);
        GroupReduceOperator dictionary;
        ExecutionEnvironment env = config.getExecutionEnvironment();
        if (this.hasVertexDictionary()) {
            dictionary = env.createInput((InputFormat)HadoopInputs.readHadoopFile((FileInputFormat)new TextInputFormat(), LongWritable.class, Text.class, (String)this.getTLFVertexDictionaryPath())).filter((FilterFunction & Serializable)t -> !((Text)t.f1).toString().isEmpty()).map((MapFunction)new DictionaryEntry()).reduceGroup((GroupReduceFunction)new Dictionary());
            this.setVertexDictionary((DataSet)dictionary);
        }
        if (this.hasEdgeDictionary()) {
            dictionary = env.createInput((InputFormat)HadoopInputs.readHadoopFile((FileInputFormat)new TextInputFormat(), LongWritable.class, Text.class, (String)this.getTLFEdgeDictionaryPath())).filter((FilterFunction & Serializable)t -> !((Text)t.f1).toString().isEmpty()).map((MapFunction)new DictionaryEntry()).reduceGroup((GroupReduceFunction)new Dictionary());
            this.setEdgeDictionary((DataSet)dictionary);
        }
    }

    @Override
    public LogicalGraph getLogicalGraph() throws IOException {
        return (LogicalGraph)this.getGraphCollection().reduce(new ReduceCombination());
    }

    @Override
    public GraphCollection getGraphCollection() throws IOException {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        DataSource input = null;
        input = env.createInput((InputFormat)HadoopInputs.readHadoopFile((org.apache.hadoop.mapreduce.lib.input.FileInputFormat)new TLFInputFormat(), LongWritable.class, Text.class, (String)this.getTLFPath()));
        assert (input != null);
        MapOperator transactions = input.map((MapFunction)new GraphTransactionFromText(this.getConfig()));
        if (this.hasVertexDictionary()) {
            transactions = transactions.map((MapFunction)new VertexLabelDecoder()).withBroadcastSet(this.getVertexDictionary(), "vertexDictionary");
        }
        if (this.hasEdgeDictionary()) {
            transactions = transactions.map((MapFunction)new EdgeLabelDecoder()).withBroadcastSet(this.getEdgeDictionary(), "edgeDictionary");
        }
        return this.getConfig().getGraphCollectionFactory().fromTransactions((DataSet)transactions);
    }
}

