/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.functions;

import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class EdgeLabelDecoder
extends RichMapFunction<GraphTransaction, GraphTransaction> {
    private Map<Integer, String> edgeDictionary;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.edgeDictionary = (Map)this.getRuntimeContext().getBroadcastVariable("edgeDictionary").get(0);
    }

    public GraphTransaction map(GraphTransaction graphTransaction) throws Exception {
        for (EPGMEdge edge : graphTransaction.getEdges()) {
            String label = this.edgeDictionary.get(Integer.parseInt(edge.getLabel()));
            if (label != null) {
                edge.setLabel(label);
                continue;
            }
            edge.setLabel(edge.getLabel() + "");
        }
        return graphTransaction;
    }
}

