/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.functions;

import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class ElementLabelEncoder
extends RichMapFunction<GraphTransaction, GraphTransaction> {
    private boolean hasVertexDictionary;
    private boolean hasEdgeDictionary;
    private Map<String, Integer> vertexDictionary;
    private Map<String, Integer> edgeDictionary;

    public ElementLabelEncoder(boolean hasVertexDictionary, boolean hasEdgeDictionary) {
        this.hasVertexDictionary = hasVertexDictionary;
        this.hasEdgeDictionary = hasEdgeDictionary;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        if (this.hasVertexDictionary) {
            this.vertexDictionary = (Map)this.getRuntimeContext().getBroadcastVariable("vertexDictionary").get(0);
        }
        if (this.hasEdgeDictionary) {
            this.edgeDictionary = (Map)this.getRuntimeContext().getBroadcastVariable("edgeDictionary").get(0);
        }
    }

    public GraphTransaction map(GraphTransaction graphTransaction) throws Exception {
        if (this.vertexDictionary != null) {
            for (EPGMVertex vertex : graphTransaction.getVertices()) {
                vertex.setLabel(this.vertexDictionary.get(vertex.getLabel()).toString());
            }
        }
        if (this.edgeDictionary != null) {
            for (EPGMEdge edge : graphTransaction.getEdges()) {
                edge.setLabel(this.edgeDictionary.get(edge.getLabel()).toString());
            }
        }
        return graphTransaction;
    }
}

