/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class GraphTransactionFromText
implements MapFunction<Tuple2<LongWritable, Text>, GraphTransaction> {
    private GraphHeadFactory<EPGMGraphHead> graphHeadFactory;
    private VertexFactory<EPGMVertex> vertexFactory;
    private EdgeFactory<EPGMEdge> edgeFactory;

    public GraphTransactionFromText(GradoopFlinkConfig config) {
        this.graphHeadFactory = config.getLogicalGraphFactory().getGraphHeadFactory();
        this.vertexFactory = config.getLogicalGraphFactory().getVertexFactory();
        this.edgeFactory = config.getLogicalGraphFactory().getEdgeFactory();
    }

    public GraphTransaction map(Tuple2<LongWritable, Text> inputTuple) throws Exception {
        HashMap<Long, GradoopId> idMap = new HashMap<Long, GradoopId>();
        HashSet<EPGMVertex> vertices = new HashSet<EPGMVertex>();
        HashSet<EPGMEdge> edges = new HashSet<EPGMEdge>();
        EPGMGraphHead graphHead = null;
        String[] lines = ((Text)inputTuple.f1).toString().split("\\R", -1);
        for (int i = 0; i < lines.length; ++i) {
            String[] fields = lines[i].trim().split(" ");
            GradoopId gradoopId = GradoopId.get();
            if (i == 0) {
                idMap.put(Long.valueOf(fields[2]), gradoopId);
                graphHead = (EPGMGraphHead)this.graphHeadFactory.initGraphHead(gradoopId);
                continue;
            }
            if ("v".equals(fields[0])) {
                idMap.put(Long.valueOf(fields[1]), gradoopId);
                EPGMVertex vertex = (EPGMVertex)this.vertexFactory.initVertex(gradoopId, this.getLabel(fields, 2));
                vertex.addGraphId(graphHead.getId());
                vertices.add(vertex);
                continue;
            }
            if (!"e".equals(fields[0])) continue;
            EPGMEdge edge = (EPGMEdge)this.edgeFactory.initEdge(gradoopId, this.getLabel(fields, 3), (GradoopId)idMap.get(Long.valueOf(fields[1])), (GradoopId)idMap.get(Long.valueOf(fields[2])));
            edge.addGraphId(graphHead.getId());
            edges.add(edge);
        }
        return new GraphTransaction(graphHead, vertices, edges);
    }

    private String getLabel(String[] fields, int labelStart) {
        return Arrays.stream(fields).skip(labelStart).collect(Collectors.joining(" "));
    }
}

