/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.functions;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class TLFFileFormat
implements TextOutputFormat.TextFormatter<GraphTransaction> {
    private long graphId = 0L;
    private Map<GradoopId, Long> vertexIdMap;

    public String format(GraphTransaction graphTransaction) {
        StringBuilder builder = new StringBuilder();
        this.vertexIdMap = Maps.newHashMapWithExpectedSize((int)graphTransaction.getVertices().size());
        this.writeGraphHead(builder, this.graphId);
        ++this.graphId;
        this.writeVertices(builder, graphTransaction.getVertices());
        this.writeEdges(builder, graphTransaction.getEdges());
        return builder.toString().trim();
    }

    private StringBuilder writeGraphHead(StringBuilder builder, long graphId) {
        return builder.append(String.format("%s %s %s%n", "t", "#", graphId));
    }

    private StringBuilder writeVertices(StringBuilder builder, Set<EPGMVertex> vertices) {
        long vertexId = 0L;
        for (EPGMVertex vertex : vertices) {
            this.vertexIdMap.put(vertex.getId(), vertexId);
            builder.append(String.format("%s %s %s%n", "v", vertexId, vertex.getLabel()));
            ++vertexId;
        }
        return builder;
    }

    private StringBuilder writeEdges(StringBuilder builder, Set<EPGMEdge> edges) {
        for (EPGMEdge edge : edges) {
            Long sourceId = this.vertexIdMap.get(edge.getSourceId());
            Long targetId = this.vertexIdMap.get(edge.getTargetId());
            builder.append(String.format("%s %s %s %s%n", "e", sourceId, targetId, edge.getLabel()));
        }
        return builder;
    }
}

