/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.functions;

import java.util.Map;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class VertexLabelDecoder
extends RichMapFunction<GraphTransaction, GraphTransaction> {
    private Map<Integer, String> vertexDictionary;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.vertexDictionary = (Map)this.getRuntimeContext().getBroadcastVariable("vertexDictionary").get(0);
    }

    public GraphTransaction map(GraphTransaction graphTransaction) throws Exception {
        for (EPGMVertex vertex : graphTransaction.getVertices()) {
            String label = this.vertexDictionary.get(Integer.parseInt(vertex.getLabel()));
            if (label != null) {
                vertex.setLabel(label);
                continue;
            }
            vertex.setLabel(vertex.getLabel() + "");
        }
        return graphTransaction;
    }
}

