/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.io.impl.tlf.inputformats;

import java.io.IOException;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class TLFRecordReader
extends RecordReader<LongWritable, Text> {
    private final long start;
    private final long end;
    private final FSDataInputStream fsin;
    private final DataOutputBuffer buffer = new DataOutputBuffer();
    private LongWritable currentKey;
    private Text currentValue;
    private int valueLength;

    public TLFRecordReader(FileSplit split, Configuration conf) throws IOException {
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.fsin = fs.open(split.getPath());
        this.fsin.seek(this.start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean next(LongWritable key, Text value) throws IOException {
        if (this.fsin.getPos() < this.end && this.readUntilMatch("t #".getBytes(Charsets.UTF_8), false)) {
            try {
                this.buffer.write("t #".getBytes(Charsets.UTF_8));
                if (this.readUntilMatch("t #".getBytes(Charsets.UTF_8), true)) {
                    key.set(this.fsin.getPos());
                    this.valueLength = this.fsin.getPos() != this.end ? this.buffer.getLength() - "t #".getBytes(Charsets.UTF_8).length : this.buffer.getLength();
                    value.set(this.buffer.getData(), 0, this.valueLength);
                    this.fsin.seek(this.fsin.getPos() - (long)"t #".getBytes(Charsets.UTF_8).length);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.buffer.reset();
            }
        }
        return false;
    }

    private boolean readUntilMatch(byte[] match, boolean withinBlock) throws IOException {
        int i = 0;
        do {
            int b;
            if ((b = this.fsin.read()) == -1) {
                return true;
            }
            if (withinBlock) {
                this.buffer.write(b);
            }
            if (b == match[i]) {
                if (++i < match.length) continue;
                return true;
            }
            i = 0;
        } while (withinBlock || i != 0 || this.fsin.getPos() < this.end);
        return false;
    }

    public void close() throws IOException {
        this.fsin.close();
        this.buffer.close();
    }

    public float getProgress() throws IOException {
        return (float)(this.fsin.getPos() - this.start) / (float)(this.end - this.start);
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.currentKey = new LongWritable();
        this.currentValue = new Text();
        return this.next(this.currentKey, this.currentValue);
    }
}

