/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.api.epgm;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionOperators;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.impl.functions.bool.Not;
import org.gradoop.flink.model.impl.functions.bool.Or;
import org.gradoop.flink.model.impl.functions.bool.True;
import org.gradoop.flink.model.impl.functions.epgm.BySameId;
import org.gradoop.flink.model.impl.functions.graphcontainment.InAnyGraph;
import org.gradoop.flink.model.impl.functions.graphcontainment.InGraph;
import org.gradoop.flink.util.GradoopFlinkConfig;

public interface BaseGraphCollection<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends GraphCollectionLayout<G, V, E>,
BaseGraphCollectionOperators<G, V, E, LG, GC> {
    public GradoopFlinkConfig getConfig();

    public BaseGraphCollectionFactory<G, V, E, LG, GC> getFactory();

    public BaseGraphFactory<G, V, E, LG, GC> getGraphFactory();

    @Override
    default public LG getGraph(GradoopId graphID) {
        FilterOperator graphHead = this.getGraphHeads().filter(new BySameId(graphID));
        FilterOperator vertices = this.getVertices().filter(new InGraph(graphID));
        FilterOperator edges = this.getEdges().filter(new InGraph(graphID));
        return this.getGraphFactory().fromDataSets((DataSet<G>)graphHead, (DataSet<V>)vertices, (DataSet<E>)edges);
    }

    @Override
    default public GC getGraphs(GradoopIdSet identifiers) {
        FilterOperator newGraphHeads = this.getGraphHeads().filter((FilterFunction & Serializable)graphHead -> identifiers.contains((Object)graphHead.getId()));
        FilterOperator vertices = this.getVertices().filter(new InAnyGraph(identifiers));
        FilterOperator edges = this.getEdges().filter(new InAnyGraph(identifiers));
        return this.getFactory().fromDataSets((DataSet<G>)newGraphHeads, (DataSet<V>)vertices, (DataSet<E>)edges);
    }

    @Override
    default public DataSet<Boolean> isEmpty() {
        return this.getGraphHeads().map(new True()).distinct().union((DataSet)this.getConfig().getExecutionEnvironment().fromElements((Object[])new Boolean[]{false})).reduce((ReduceFunction)new Or()).map((MapFunction)new Not());
    }
}

