/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.api.epgm;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.GraphHeadReduceFunction;
import org.gradoop.flink.model.api.operators.ApplicableUnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphCollectionToBaseGraphCollectionOperator;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphCollectionToValueOperator;
import org.gradoop.flink.model.api.operators.ReducibleBinaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToBaseGraphCollectionOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToBaseGraphOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToValueOperator;
import org.gradoop.flink.model.impl.operators.difference.Difference;
import org.gradoop.flink.model.impl.operators.difference.DifferenceBroadcast;
import org.gradoop.flink.model.impl.operators.distinction.DistinctById;
import org.gradoop.flink.model.impl.operators.distinction.DistinctByIsomorphism;
import org.gradoop.flink.model.impl.operators.distinction.GroupByIsomorphism;
import org.gradoop.flink.model.impl.operators.equality.CollectionEquality;
import org.gradoop.flink.model.impl.operators.equality.CollectionEqualityByGraphIds;
import org.gradoop.flink.model.impl.operators.intersection.Intersection;
import org.gradoop.flink.model.impl.operators.intersection.IntersectionBroadcast;
import org.gradoop.flink.model.impl.operators.limit.Limit;
import org.gradoop.flink.model.impl.operators.matching.transactional.TransactionalPatternMatching;
import org.gradoop.flink.model.impl.operators.matching.transactional.algorithm.PatternMatchingAlgorithm;
import org.gradoop.flink.model.impl.operators.selection.Selection;
import org.gradoop.flink.model.impl.operators.tostring.functions.EdgeToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.EdgeToIdString;
import org.gradoop.flink.model.impl.operators.tostring.functions.GraphHeadToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.GraphHeadToEmptyString;
import org.gradoop.flink.model.impl.operators.tostring.functions.VertexToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.VertexToIdString;
import org.gradoop.flink.model.impl.operators.union.Union;
import org.gradoop.flink.model.impl.operators.verify.VerifyCollection;
import org.gradoop.flink.model.impl.operators.verify.VerifyGraphsContainment;

public interface BaseGraphCollectionOperators<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> {
    public LG getGraph(GradoopId var1);

    default public GC getGraphs(GradoopId ... identifiers) {
        return this.getGraphs(GradoopIdSet.fromExisting((GradoopId[])identifiers));
    }

    public GC getGraphs(GradoopIdSet var1);

    default public GC select(FilterFunction<G> predicateFunction) {
        return this.callForCollection(new Selection(predicateFunction));
    }

    default public GC limit(int n) {
        return this.callForCollection(new Limit(n));
    }

    default public GC query(String query, PatternMatchingAlgorithm algorithm, boolean returnEmbeddings) {
        return this.callForCollection(new TransactionalPatternMatching(query, algorithm, returnEmbeddings));
    }

    default public GC verify() {
        return this.callForCollection(new VerifyCollection());
    }

    default public GC verifyGraphsContainment() {
        return this.callForCollection(new VerifyGraphsContainment());
    }

    default public GC union(GC otherCollection) {
        return this.callForCollection(new Union(), otherCollection);
    }

    default public GC intersect(GC otherCollection) {
        return this.callForCollection(new Intersection(), otherCollection);
    }

    default public GC intersectWithSmallResult(GC otherCollection) {
        return this.callForCollection(new IntersectionBroadcast(), otherCollection);
    }

    default public GC difference(GC otherCollection) {
        return this.callForCollection(new Difference(), otherCollection);
    }

    default public GC differenceWithSmallResult(GC otherCollection) {
        return this.callForCollection(new DifferenceBroadcast(), otherCollection);
    }

    default public DataSet<Boolean> equalsByGraphIds(GC otherCollection) {
        return (DataSet)this.callForValue(new CollectionEqualityByGraphIds(), otherCollection);
    }

    default public DataSet<Boolean> equalsByGraphElementIds(GC otherCollection) {
        return (DataSet)this.callForValue(new CollectionEquality(new GraphHeadToEmptyString(), new VertexToIdString(), new EdgeToIdString(), true), otherCollection);
    }

    default public DataSet<Boolean> equalsByGraphElementData(GC otherCollection) {
        return (DataSet)this.callForValue(new CollectionEquality(new GraphHeadToEmptyString(), new VertexToDataString(), new EdgeToDataString(), true), otherCollection);
    }

    default public DataSet<Boolean> equalsByGraphData(GC otherCollection) {
        return (DataSet)this.callForValue(new CollectionEquality(new GraphHeadToDataString(), new VertexToDataString(), new EdgeToDataString(), true), otherCollection);
    }

    public DataSet<Boolean> isEmpty();

    default public GC distinctById() {
        return this.callForCollection(new DistinctById());
    }

    default public GC distinctByIsomorphism() {
        return this.callForCollection(new DistinctByIsomorphism());
    }

    default public GC groupByIsomorphism(GraphHeadReduceFunction<G> reduceFunction) {
        return this.callForCollection(new GroupByIsomorphism(reduceFunction));
    }

    public <T> T callForValue(UnaryBaseGraphCollectionToValueOperator<GC, T> var1);

    public <T> T callForValue(BinaryBaseGraphCollectionToValueOperator<GC, T> var1, GC var2);

    default public LG callForGraph(UnaryBaseGraphCollectionToBaseGraphOperator<GC, LG> operator) {
        return (LG)((BaseGraph)this.callForValue(operator));
    }

    default public GC callForCollection(UnaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> operator) {
        return (GC)((BaseGraphCollection)this.callForValue(operator));
    }

    default public GC callForCollection(BinaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> operator, GC otherCollection) {
        return (GC)((BaseGraphCollection)this.callForValue(operator, otherCollection));
    }

    default public GC apply(ApplicableUnaryBaseGraphToBaseGraphOperator<GC> operator) {
        return (GC)((BaseGraphCollection)this.callForValue(operator));
    }

    default public LG reduce(ReducibleBinaryBaseGraphToBaseGraphOperator<GC, LG> operator) {
        return (LG)((BaseGraph)this.callForValue(operator));
    }
}

