/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.api.epgm;

import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.functions.EdgeAggregateFunction;
import org.gradoop.flink.model.api.functions.TransformationFunction;
import org.gradoop.flink.model.api.functions.VertexAggregateFunction;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphToValueOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphCollectionOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToValueOperator;
import org.gradoop.flink.model.impl.operators.aggregation.Aggregation;
import org.gradoop.flink.model.impl.operators.cloning.Cloning;
import org.gradoop.flink.model.impl.operators.combination.Combination;
import org.gradoop.flink.model.impl.operators.equality.GraphEquality;
import org.gradoop.flink.model.impl.operators.exclusion.Exclusion;
import org.gradoop.flink.model.impl.operators.grouping.Grouping;
import org.gradoop.flink.model.impl.operators.grouping.GroupingStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.CypherPatternMatching;
import org.gradoop.flink.model.impl.operators.neighborhood.Neighborhood;
import org.gradoop.flink.model.impl.operators.neighborhood.ReduceEdgeNeighborhood;
import org.gradoop.flink.model.impl.operators.neighborhood.ReduceVertexNeighborhood;
import org.gradoop.flink.model.impl.operators.overlap.Overlap;
import org.gradoop.flink.model.impl.operators.subgraph.Subgraph;
import org.gradoop.flink.model.impl.operators.tostring.functions.EdgeToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.EdgeToIdString;
import org.gradoop.flink.model.impl.operators.tostring.functions.GraphHeadToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.GraphHeadToEmptyString;
import org.gradoop.flink.model.impl.operators.tostring.functions.VertexToDataString;
import org.gradoop.flink.model.impl.operators.tostring.functions.VertexToIdString;
import org.gradoop.flink.model.impl.operators.transformation.Transformation;
import org.gradoop.flink.model.impl.operators.verify.Verify;
import org.gradoop.flink.model.impl.operators.verify.VerifyGraphContainment;

public interface BaseGraphOperators<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> {
    default public GC query(String query) {
        return this.query(query, new GraphStatistics(1L, 1L, 1L, 1L));
    }

    default public GC query(String query, String constructionPattern) {
        return this.query(query, constructionPattern, new GraphStatistics(1L, 1L, 1L, 1L));
    }

    default public GC query(String query, GraphStatistics graphStatistics) {
        return this.query(query, true, MatchStrategy.HOMOMORPHISM, MatchStrategy.ISOMORPHISM, graphStatistics);
    }

    default public GC query(String query, String constructionPattern, GraphStatistics graphStatistics) {
        return this.query(query, constructionPattern, true, MatchStrategy.HOMOMORPHISM, MatchStrategy.ISOMORPHISM, graphStatistics);
    }

    default public GC query(String query, boolean attachData, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, GraphStatistics graphStatistics) {
        return this.query(query, null, attachData, vertexStrategy, edgeStrategy, graphStatistics);
    }

    default public GC query(String query, String constructionPattern, boolean attachData, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, GraphStatistics graphStatistics) {
        return this.callForCollection(new CypherPatternMatching(query, constructionPattern, attachData, vertexStrategy, edgeStrategy, graphStatistics));
    }

    default public LG copy() {
        return this.callForGraph(new Cloning());
    }

    default public LG groupBy(List<String> vertexGroupingKeys) {
        return this.groupBy(vertexGroupingKeys, null);
    }

    default public LG groupBy(List<String> vertexGroupingKeys, List<String> edgeGroupingKeys) {
        return this.groupBy(vertexGroupingKeys, null, edgeGroupingKeys, null, GroupingStrategy.GROUP_REDUCE);
    }

    default public LG groupBy(List<String> vertexGroupingKeys, List<AggregateFunction> vertexAggregateFunctions, List<String> edgeGroupingKeys, List<AggregateFunction> edgeAggregateFunctions, GroupingStrategy groupingStrategy) {
        Objects.requireNonNull(vertexGroupingKeys, "missing vertex grouping key(s)");
        Objects.requireNonNull(groupingStrategy, "missing vertex grouping strategy");
        Grouping.GroupingBuilder builder = new Grouping.GroupingBuilder();
        builder.addVertexGroupingKeys(vertexGroupingKeys);
        builder.setStrategy(groupingStrategy);
        if (edgeGroupingKeys != null) {
            builder.addEdgeGroupingKeys(edgeGroupingKeys);
        }
        if (vertexAggregateFunctions != null) {
            vertexAggregateFunctions.forEach(builder::addVertexAggregateFunction);
        }
        if (edgeAggregateFunctions != null) {
            edgeAggregateFunctions.forEach(builder::addEdgeAggregateFunction);
        }
        return this.callForGraph(builder.build());
    }

    default public LG transform(TransformationFunction<G> graphHeadTransformationFunction, TransformationFunction<V> vertexTransformationFunction, TransformationFunction<E> edgeTransformationFunction) {
        return this.callForGraph(new Transformation(graphHeadTransformationFunction, vertexTransformationFunction, edgeTransformationFunction));
    }

    default public LG transformGraphHead(TransformationFunction<G> graphHeadTransformationFunction) {
        return this.transform(graphHeadTransformationFunction, null, null);
    }

    default public LG transformVertices(TransformationFunction<V> vertexTransformationFunction) {
        return this.transform(null, vertexTransformationFunction, null);
    }

    default public LG transformEdges(TransformationFunction<E> edgeTransformationFunction) {
        return this.transform(null, null, edgeTransformationFunction);
    }

    default public LG vertexInducedSubgraph(FilterFunction<V> vertexFilterFunction) {
        Objects.requireNonNull(vertexFilterFunction);
        return this.callForGraph(new Subgraph(vertexFilterFunction, null, Subgraph.Strategy.VERTEX_INDUCED));
    }

    default public LG edgeInducedSubgraph(FilterFunction<E> edgeFilterFunction) {
        Objects.requireNonNull(edgeFilterFunction);
        return this.callForGraph(new Subgraph(null, edgeFilterFunction, Subgraph.Strategy.EDGE_INDUCED));
    }

    default public LG subgraph(FilterFunction<V> vertexFilterFunction, FilterFunction<E> edgeFilterFunction) {
        Objects.requireNonNull(vertexFilterFunction);
        Objects.requireNonNull(edgeFilterFunction);
        return this.subgraph(vertexFilterFunction, edgeFilterFunction, Subgraph.Strategy.BOTH);
    }

    default public LG subgraph(FilterFunction<V> vertexFilterFunction, FilterFunction<E> edgeFilterFunction, Subgraph.Strategy strategy) {
        return this.callForGraph(new Subgraph(vertexFilterFunction, edgeFilterFunction, strategy));
    }

    default public LG aggregate(AggregateFunction ... aggregateFunctions) {
        return this.callForGraph(new Aggregation(aggregateFunctions));
    }

    default public LG reduceOnEdges(EdgeAggregateFunction function, Neighborhood.EdgeDirection edgeDirection) {
        return this.callForGraph(new ReduceEdgeNeighborhood(function, edgeDirection));
    }

    default public LG reduceOnNeighbors(VertexAggregateFunction function, Neighborhood.EdgeDirection edgeDirection) {
        return this.callForGraph(new ReduceVertexNeighborhood(function, edgeDirection));
    }

    default public LG verify() {
        return this.callForGraph(new Verify());
    }

    default public LG verifyGraphContainment() {
        return this.callForGraph(new VerifyGraphContainment());
    }

    default public LG combine(LG otherGraph) {
        return this.callForGraph(new Combination(), otherGraph);
    }

    default public LG overlap(LG otherGraph) {
        return this.callForGraph(new Overlap(), otherGraph);
    }

    default public LG exclude(LG otherGraph) {
        return this.callForGraph(new Exclusion(), otherGraph);
    }

    default public DataSet<Boolean> equalsByElementIds(LG other) {
        return (DataSet)this.callForValue(new GraphEquality(new GraphHeadToEmptyString(), new VertexToIdString(), new EdgeToIdString(), true), other);
    }

    default public DataSet<Boolean> equalsByElementData(LG other) {
        return (DataSet)this.callForValue(new GraphEquality(new GraphHeadToEmptyString(), new VertexToDataString(), new EdgeToDataString(), true), other);
    }

    default public DataSet<Boolean> equalsByData(LG other) {
        return (DataSet)this.callForValue(new GraphEquality(new GraphHeadToDataString(), new VertexToDataString(), new EdgeToDataString(), true), other);
    }

    public DataSet<Boolean> isEmpty();

    public <T> T callForValue(UnaryBaseGraphToValueOperator<LG, T> var1);

    public <T> T callForValue(BinaryBaseGraphToValueOperator<LG, T> var1, LG var2);

    default public LG callForGraph(UnaryBaseGraphToBaseGraphOperator<LG> operator) {
        return (LG)((BaseGraph)this.callForValue(operator));
    }

    default public LG callForGraph(BinaryBaseGraphToBaseGraphOperator<LG> operator, LG otherGraph) {
        return (LG)((BaseGraph)this.callForValue(operator, otherGraph));
    }

    default public GC callForCollection(UnaryBaseGraphToBaseGraphCollectionOperator<LG, GC> operator) {
        return (GC)((BaseGraphCollection)this.callForValue(operator));
    }
}

