/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.epgm;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.UnionOperator;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayoutFactory;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class GraphCollectionFactory
implements BaseGraphCollectionFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> {
    private GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> layoutFactory;
    private final GradoopFlinkConfig config;

    public GraphCollectionFactory(GradoopFlinkConfig config) {
        this.config = config;
    }

    @Override
    public GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> getLayoutFactory() {
        return this.layoutFactory;
    }

    @Override
    public void setLayoutFactory(GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> layoutFactory) {
        Objects.requireNonNull(layoutFactory);
        this.layoutFactory = layoutFactory;
        this.layoutFactory.setGradoopFlinkConfig(this.config);
    }

    public GraphHeadFactory<EPGMGraphHead> getGraphHeadFactory() {
        return this.layoutFactory.getGraphHeadFactory();
    }

    public VertexFactory<EPGMVertex> getVertexFactory() {
        return this.layoutFactory.getVertexFactory();
    }

    public EdgeFactory<EPGMEdge> getEdgeFactory() {
        return this.layoutFactory.getEdgeFactory();
    }

    @Override
    public GraphCollection fromDataSets(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices) {
        return new GraphCollection(this.layoutFactory.fromDataSets(graphHeads, vertices), this.config);
    }

    @Override
    public GraphCollection fromDataSets(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        return new GraphCollection(this.layoutFactory.fromDataSets(graphHeads, vertices, edges), this.config);
    }

    @Override
    public GraphCollection fromIndexedDataSets(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> layout = this.layoutFactory.fromIndexedDataSets(graphHeads, vertices, edges);
        return new GraphCollection(layout, this.config);
    }

    @Override
    public GraphCollection fromCollections(Collection<EPGMGraphHead> graphHeads, Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        return new GraphCollection(this.layoutFactory.fromCollections(graphHeads, vertices, edges), this.config);
    }

    @Override
    public GraphCollection fromGraph(LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> logicalGraphLayout) {
        return new GraphCollection(this.layoutFactory.fromGraphLayout(logicalGraphLayout), this.config);
    }

    @Override
    public GraphCollection fromGraphs(LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> ... logicalGraphLayouts) {
        if (logicalGraphLayouts.length != 0) {
            UnionOperator graphHeads = null;
            UnionOperator vertices = null;
            UnionOperator edges = null;
            if (logicalGraphLayouts.length == 1) {
                return this.fromGraph((LogicalGraphLayout)logicalGraphLayouts[0]);
            }
            for (LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> logicalGraph : logicalGraphLayouts) {
                graphHeads = graphHeads == null ? logicalGraph.getGraphHead() : graphHeads.union(logicalGraph.getGraphHead());
                vertices = vertices == null ? logicalGraph.getVertices() : vertices.union(logicalGraph.getVertices());
                edges = edges == null ? logicalGraph.getEdges() : edges.union(logicalGraph.getEdges());
            }
            return this.fromDataSets((DataSet)graphHeads.distinct(new Id()), (DataSet)vertices.distinct(new Id()), (DataSet)edges.distinct(new Id()));
        }
        return this.createEmptyCollection();
    }

    @Override
    public GraphCollection fromTransactions(DataSet<GraphTransaction> transactions) {
        return new GraphCollection(this.layoutFactory.fromTransactions(transactions), this.config);
    }

    @Override
    public GraphCollection fromTransactions(DataSet<GraphTransaction> transactions, GroupReduceFunction<EPGMVertex, EPGMVertex> vertexMergeReducer, GroupReduceFunction<EPGMEdge, EPGMEdge> edgeMergeReducer) {
        return new GraphCollection(this.layoutFactory.fromTransactions(transactions, vertexMergeReducer, edgeMergeReducer), this.config);
    }

    @Override
    public GraphCollection createEmptyCollection() {
        return new GraphCollection(this.layoutFactory.createEmptyCollection(), this.config);
    }
}

