/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.epgm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.impl.metadata.MetaData;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.io.api.DataSink;
import org.gradoop.flink.io.impl.gdl.GDLConsoleOutput;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.api.epgm.LogicalGraphOperators;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphToValueOperator;
import org.gradoop.flink.model.api.operators.GraphsToGraphOperator;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToValueOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.functions.epgm.PropertyGetter;
import org.gradoop.flink.model.impl.operators.cypher.capf.query.CAPFQuery;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.CAPFQueryResult;
import org.gradoop.flink.model.impl.operators.rollup.EdgeRollUp;
import org.gradoop.flink.model.impl.operators.rollup.VertexRollUp;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.split.Split;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class LogicalGraph
implements BaseGraph<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection>,
LogicalGraphOperators {
    private final LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> layout;
    private final GradoopFlinkConfig config;

    LogicalGraph(LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> layout, GradoopFlinkConfig config) {
        Objects.requireNonNull(layout);
        Objects.requireNonNull(config);
        this.layout = layout;
        this.config = config;
    }

    @Override
    public GradoopFlinkConfig getConfig() {
        return this.config;
    }

    @Override
    public BaseGraphFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> getFactory() {
        return this.config.getLogicalGraphFactory();
    }

    @Override
    public BaseGraphCollectionFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> getCollectionFactory() {
        return this.config.getGraphCollectionFactory();
    }

    @Override
    public boolean isGVELayout() {
        return this.layout.isGVELayout();
    }

    @Override
    public boolean isIndexedGVELayout() {
        return this.layout.isIndexedGVELayout();
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHead() {
        return this.layout.getGraphHead();
    }

    @Override
    public DataSet<EPGMVertex> getVertices() {
        return this.layout.getVertices();
    }

    @Override
    public DataSet<EPGMVertex> getVerticesByLabel(String label) {
        return this.layout.getVerticesByLabel(label);
    }

    @Override
    public DataSet<EPGMEdge> getEdges() {
        return this.layout.getEdges();
    }

    @Override
    public DataSet<EPGMEdge> getEdgesByLabel(String label) {
        return this.layout.getEdgesByLabel(label);
    }

    @Override
    public CAPFQueryResult cypher(String query) throws Exception {
        CAPFQuery capfQuery = new CAPFQuery(query, this.config.getExecutionEnvironment());
        return capfQuery.execute(this);
    }

    @Override
    public CAPFQueryResult cypher(String query, MetaData metaData) throws Exception {
        CAPFQuery capfQuery = new CAPFQuery(query, metaData, this.config.getExecutionEnvironment());
        return capfQuery.execute(this);
    }

    @Override
    public LogicalGraph sample(SamplingAlgorithm algorithm) {
        return this.callForGraph(algorithm);
    }

    @Override
    public GraphCollection groupVerticesByRollUp(List<String> vertexGroupingKeys, List<AggregateFunction> vertexAggregateFunctions, List<String> edgeGroupingKeys, List<AggregateFunction> edgeAggregateFunctions) {
        if (vertexGroupingKeys == null || vertexGroupingKeys.isEmpty()) {
            throw new IllegalArgumentException("Missing vertex grouping key(s).");
        }
        return this.callForCollection(new VertexRollUp(vertexGroupingKeys, vertexAggregateFunctions, edgeGroupingKeys, edgeAggregateFunctions));
    }

    @Override
    public GraphCollection groupEdgesByRollUp(List<String> vertexGroupingKeys, List<AggregateFunction> vertexAggregateFunctions, List<String> edgeGroupingKeys, List<AggregateFunction> edgeAggregateFunctions) {
        if (edgeGroupingKeys == null || edgeGroupingKeys.isEmpty()) {
            throw new IllegalArgumentException("Missing edge grouping key(s).");
        }
        return this.callForCollection(new EdgeRollUp(vertexGroupingKeys, vertexAggregateFunctions, edgeGroupingKeys, edgeAggregateFunctions));
    }

    @Override
    public <T> T callForValue(UnaryBaseGraphToValueOperator<LogicalGraph, T> operator) {
        return operator.execute(this);
    }

    @Override
    public <T> T callForValue(BinaryBaseGraphToValueOperator<LogicalGraph, T> operator, LogicalGraph otherGraph) {
        return operator.execute(this, otherGraph);
    }

    @Override
    public LogicalGraph callForGraph(GraphsToGraphOperator operator, LogicalGraph ... otherGraphs) {
        return operator.execute(this, otherGraphs);
    }

    @Override
    public GraphCollection splitBy(String propertyKey) {
        return this.callForCollection(new Split(new PropertyGetter<EPGMVertex>(Lists.newArrayList((Object[])new String[]{propertyKey}))));
    }

    @Override
    public void writeTo(DataSink dataSink) throws IOException {
        dataSink.write(this);
    }

    @Override
    public void writeTo(DataSink dataSink, boolean overWrite) throws IOException {
        dataSink.write(this, overWrite);
    }

    public void print() throws Exception {
        GDLConsoleOutput.print(this);
    }
}

