/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.epgm;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayoutFactory;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class LogicalGraphFactory
implements BaseGraphFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> {
    private LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> layoutFactory;
    private final GradoopFlinkConfig config;

    public LogicalGraphFactory(GradoopFlinkConfig config) {
        this.config = config;
    }

    @Override
    public LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> getLayoutFactory() {
        return this.layoutFactory;
    }

    @Override
    public void setLayoutFactory(LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> layoutFactory) {
        Objects.requireNonNull(layoutFactory);
        this.layoutFactory = layoutFactory;
        this.layoutFactory.setGradoopFlinkConfig(this.config);
    }

    public GraphHeadFactory<EPGMGraphHead> getGraphHeadFactory() {
        return this.layoutFactory.getGraphHeadFactory();
    }

    public VertexFactory<EPGMVertex> getVertexFactory() {
        return this.layoutFactory.getVertexFactory();
    }

    public EdgeFactory<EPGMEdge> getEdgeFactory() {
        return this.layoutFactory.getEdgeFactory();
    }

    @Override
    public LogicalGraph fromDataSets(DataSet<EPGMVertex> vertices) {
        return new LogicalGraph(this.layoutFactory.fromDataSets(vertices), this.config);
    }

    @Override
    public LogicalGraph fromDataSets(DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        return new LogicalGraph(this.layoutFactory.fromDataSets(vertices, edges), this.config);
    }

    @Override
    public LogicalGraph fromDataSets(DataSet<EPGMGraphHead> graphHead, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        return new LogicalGraph(this.layoutFactory.fromDataSets(graphHead, vertices, edges), this.config);
    }

    @Override
    public LogicalGraph fromIndexedDataSets(Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        return new LogicalGraph(this.layoutFactory.fromIndexedDataSets(vertices, edges), this.config);
    }

    @Override
    public LogicalGraph fromIndexedDataSets(Map<String, DataSet<EPGMGraphHead>> graphHead, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        return new LogicalGraph(this.layoutFactory.fromIndexedDataSets(graphHead, vertices, edges), this.config);
    }

    @Override
    public LogicalGraph fromCollections(EPGMGraphHead graphHead, Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        return new LogicalGraph(this.layoutFactory.fromCollections(graphHead, vertices, edges), this.config);
    }

    @Override
    public LogicalGraph fromCollections(Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        return new LogicalGraph(this.layoutFactory.fromCollections(vertices, edges), this.config);
    }

    @Override
    public LogicalGraph createEmptyGraph() {
        return new LogicalGraph(this.layoutFactory.createEmptyGraph(), this.config);
    }
}

