/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.impl.id.GradoopId;

@FunctionAnnotation.ForwardedFields(value={"f0->id;f1->sourceId;f2->targetId"})
public class EdgeFromIds<E extends Edge>
implements MapFunction<Tuple3<GradoopId, GradoopId, GradoopId>, E>,
ResultTypeQueryable<E> {
    private final TypeInformation<E> edgeType;
    private final E reuseEdge;

    public EdgeFromIds(EdgeFactory<E> edgeFactory) {
        this.edgeType = TypeInformation.of((Class)edgeFactory.getType());
        this.reuseEdge = edgeFactory.createEdge(GradoopId.NULL_VALUE, GradoopId.NULL_VALUE);
    }

    public E map(Tuple3<GradoopId, GradoopId, GradoopId> idTriple) {
        this.reuseEdge.setId((GradoopId)idTriple.f0);
        this.reuseEdge.setSourceId((GradoopId)idTriple.f1);
        this.reuseEdge.setTargetId((GradoopId)idTriple.f2);
        return this.reuseEdge;
    }

    public TypeInformation<E> getProducedType() {
        return this.edgeType;
    }
}

