/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphElement;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

@FunctionAnnotation.ReadFieldsFirst(value={"f1"})
public class GraphElementsHeadsToTransaction
implements CoGroupFunction<Tuple2<GradoopId, EPGMGraphElement>, EPGMGraphHead, GraphTransaction> {
    public void coGroup(Iterable<Tuple2<GradoopId, EPGMGraphElement>> graphElements, Iterable<EPGMGraphHead> graphHeads, Collector<GraphTransaction> out) throws Exception {
        Iterator<EPGMGraphHead> graphHeadIter = graphHeads.iterator();
        if (graphHeadIter.hasNext()) {
            HashSet vertices = Sets.newHashSet();
            HashSet edges = Sets.newHashSet();
            EPGMGraphHead graphHead = graphHeadIter.next();
            for (Tuple2<GradoopId, EPGMGraphElement> graphElement : graphElements) {
                EPGMGraphElement el = (EPGMGraphElement)graphElement.f1;
                if (el instanceof EPGMVertex) {
                    vertices.add((EPGMVertex)el);
                    continue;
                }
                if (!(el instanceof EPGMEdge)) continue;
                edges.add((EPGMEdge)el);
            }
            out.collect((Object)new GraphTransaction(graphHead, vertices, edges));
        }
    }
}

