/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphElement;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

@FunctionAnnotation.ForwardedFields(value={"f0"})
public class GraphVerticesEdges
implements GroupCombineFunction<Tuple2<GradoopId, EPGMGraphElement>, Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>>,
GroupReduceFunction<Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>, Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>> {
    public void combine(Iterable<Tuple2<GradoopId, EPGMGraphElement>> values, Collector<Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>> out) throws Exception {
        Iterator<Tuple2<GradoopId, EPGMGraphElement>> iterator = values.iterator();
        GradoopId graphId = null;
        HashSet<EPGMVertex> vertices = new HashSet<EPGMVertex>();
        HashSet<EPGMEdge> edges = new HashSet<EPGMEdge>();
        while (iterator.hasNext()) {
            Tuple2<GradoopId, EPGMGraphElement> next = iterator.next();
            graphId = (GradoopId)next.f0;
            EPGMGraphElement element = (EPGMGraphElement)next.f1;
            if (element instanceof EPGMVertex) {
                vertices.add((EPGMVertex)element);
                continue;
            }
            edges.add((EPGMEdge)element);
        }
        out.collect((Object)Tuple3.of(graphId, vertices, edges));
    }

    public void reduce(Iterable<Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>> values, Collector<Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>> out) throws Exception {
        Iterator<Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>> iterator = values.iterator();
        Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>> first = iterator.next();
        GradoopId graphId = (GradoopId)first.f0;
        Set vertices = (Set)first.f1;
        Set edges = (Set)first.f2;
        while (iterator.hasNext()) {
            Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>> next = iterator.next();
            vertices.addAll((Collection)next.f1);
            edges.addAll((Collection)next.f2);
        }
        out.collect((Object)Tuple3.of((Object)graphId, (Object)vertices, (Object)edges));
    }
}

