/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradoop.common.model.impl.pojo.EPGMElement;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.Function;

public class PropertyGetter<EL extends EPGMElement>
implements Function<EL, List<PropertyValue>> {
    private final List<String> propertyKeys;

    public PropertyGetter(List<String> propertyKeys) {
        this.propertyKeys = (List)Preconditions.checkNotNull(propertyKeys);
    }

    @Override
    public List<PropertyValue> apply(EL entity) {
        ArrayList propertyValueList = Lists.newArrayListWithCapacity((int)this.propertyKeys.size());
        for (String propertyKey : this.propertyKeys) {
            if (entity.hasProperty(propertyKey)) {
                propertyValueList.add(entity.getPropertyValue(propertyKey));
                continue;
            }
            propertyValueList.add(PropertyValue.NULL_VALUE);
        }
        return propertyValueList;
    }
}

