/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import com.google.common.base.Preconditions;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMElement;

@FunctionAnnotation.ForwardedFieldsFirst(value={"id"})
public class PropertySetter<EL extends EPGMElement, T>
implements JoinFunction<EL, Tuple2<GradoopId, T>, EL> {
    private final String propertyKey;

    public PropertySetter(String propertyKey) {
        this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey);
    }

    public EL join(EL element, Tuple2<GradoopId, T> propertyTuple) throws Exception {
        element.setProperty(this.propertyKey, propertyTuple.f1);
        return element;
    }
}

