/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.flink.model.api.functions.TransformationFunction;

public class RenamePropertyKeys<T extends Element>
implements TransformationFunction<T> {
    private final Map<String, String> keyMappings;

    public RenamePropertyKeys(Map<String, String> keyMappings) {
        this.keyMappings = (Map)Preconditions.checkNotNull(keyMappings);
        for (Map.Entry<String, String> mapping : keyMappings.entrySet()) {
            Preconditions.checkNotNull((Object)mapping.getKey());
            Preconditions.checkNotNull((Object)mapping.getValue());
        }
    }

    @Override
    public T apply(T current, T transformed) {
        for (Map.Entry<String, String> mapping : this.keyMappings.entrySet()) {
            if (current.getPropertyValue(mapping.getKey()) == null) continue;
            current.setProperty(mapping.getValue(), current.getPropertyValue(mapping.getKey()));
            current.removeProperty(mapping.getKey());
        }
        return current;
    }
}

