/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.epgm;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

@FunctionAnnotation.ForwardedFieldsFirst(value={"*->f0"})
@FunctionAnnotation.ForwardedFieldsSecond(value={"f1;f2"})
public class TransactionFromSets
implements JoinFunction<EPGMGraphHead, Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>>, GraphTransaction> {
    private static final Set<EPGMVertex> EMPTY_VERTEX_SET = new HashSet<EPGMVertex>(0);
    private static final Set<EPGMEdge> EMPTY_EDGE_SET = new HashSet<EPGMEdge>(0);
    private final GraphTransaction reuseTransaction = new GraphTransaction();

    public GraphTransaction join(EPGMGraphHead graphHead, Tuple3<GradoopId, Set<EPGMVertex>, Set<EPGMEdge>> sets) throws Exception {
        this.reuseTransaction.setGraphHead(graphHead);
        this.reuseTransaction.setVertices(sets == null ? EMPTY_VERTEX_SET : (Set)sets.f1);
        this.reuseTransaction.setEdges(sets == null ? EMPTY_EDGE_SET : (Set)sets.f2);
        return this.reuseTransaction;
    }
}

