/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.functions.filters;

import java.util.Objects;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.model.impl.functions.filters.CombinableFilter;

public abstract class AbstractRichCombinedFilterFunction<T>
extends RichFilterFunction<T>
implements CombinableFilter<T> {
    protected final FilterFunction<? super T>[] components;

    @SafeVarargs
    public AbstractRichCombinedFilterFunction(FilterFunction<? super T> ... filters) {
        for (FilterFunction<? super T> filter : filters) {
            Objects.requireNonNull(filter);
        }
        this.components = filters;
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        for (FilterFunction<? super T> component : this.components) {
            if (!(component instanceof RichFunction)) continue;
            ((RichFunction)component).setRuntimeContext(t);
        }
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        for (FilterFunction<? super T> component : this.components) {
            if (!(component instanceof RichFunction)) continue;
            ((RichFunction)component).open(parameters);
        }
    }

    public void close() throws Exception {
        super.close();
        for (FilterFunction<? super T> component : this.components) {
            if (!(component instanceof RichFunction)) continue;
            ((RichFunction)component).close();
        }
    }
}

