/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.common;

import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMEdgeFactory;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMGraphHeadFactory;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.pojo.EPGMVertexFactory;
import org.gradoop.flink.model.api.layouts.BaseLayoutFactory;
import org.gradoop.flink.model.impl.functions.bool.False;
import org.gradoop.flink.util.GradoopFlinkConfig;

public abstract class BaseFactory
implements BaseLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    private GradoopFlinkConfig config;
    private final EPGMGraphHeadFactory graphHeadFactory = new EPGMGraphHeadFactory();
    private final EPGMVertexFactory vertexFactory = new EPGMVertexFactory();
    private final EPGMEdgeFactory edgeFactory = new EPGMEdgeFactory();

    protected BaseFactory() {
    }

    public GraphHeadFactory<EPGMGraphHead> getGraphHeadFactory() {
        return this.graphHeadFactory;
    }

    public VertexFactory<EPGMVertex> getVertexFactory() {
        return this.vertexFactory;
    }

    public EdgeFactory<EPGMEdge> getEdgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public void setGradoopFlinkConfig(GradoopFlinkConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    protected GradoopFlinkConfig getConfig() {
        return this.config;
    }

    protected DataSet<EPGMGraphHead> createGraphHeadDataSet(Collection<EPGMGraphHead> graphHeads) {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        Object graphHeadSet = graphHeads.isEmpty() ? env.fromElements((Object[])new EPGMGraphHead[]{(EPGMGraphHead)this.getGraphHeadFactory().createGraphHead()}).filter(new False()) : env.fromCollection(graphHeads);
        return graphHeadSet;
    }

    protected DataSet<EPGMVertex> createVertexDataSet(Collection<EPGMVertex> vertices) {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        Object vertexSet = vertices.isEmpty() ? env.fromElements((Object[])new EPGMVertex[]{(EPGMVertex)this.getVertexFactory().createVertex()}).filter(new False()) : env.fromCollection(vertices);
        return vertexSet;
    }

    protected DataSet<EPGMEdge> createEdgeDataSet(Collection<EPGMEdge> edges) {
        DataSource edgeSet;
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        if (edges.isEmpty()) {
            GradoopId dummyId = GradoopId.get();
            edgeSet = env.fromElements((Object[])new EPGMEdge[]{(EPGMEdge)this.getEdgeFactory().createEdge(dummyId, dummyId)}).filter(new False());
        } else {
            edgeSet = env.fromCollection(edges);
        }
        return edgeSet;
    }
}

