/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.gve;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.common.BaseFactory;
import org.gradoop.flink.model.impl.layouts.gve.GVELayout;

abstract class GVEBaseFactory
extends BaseFactory {
    GVEBaseFactory() {
    }

    GVELayout create(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        Objects.requireNonNull(graphHeads, "EPGMGraphHead DataSet was null");
        Objects.requireNonNull(vertices, "EPGMVertex DataSet was null");
        Objects.requireNonNull(edges, "EPGMEdge DataSet was null");
        return new GVELayout(graphHeads, vertices, edges);
    }

    GVELayout create(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        Objects.requireNonNull(graphHeads);
        Objects.requireNonNull(vertices);
        Objects.requireNonNull(edges);
        return new GVELayout(graphHeads.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during graph head union")), vertices.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during vertex union")), edges.values().stream().reduce(this.createEdgeDataSet(Collections.EMPTY_LIST), DataSet::union));
    }
}

