/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.gve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayoutFactory;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.TransactionEdges;
import org.gradoop.flink.model.impl.functions.epgm.TransactionGraphHead;
import org.gradoop.flink.model.impl.functions.epgm.TransactionVertices;
import org.gradoop.flink.model.impl.functions.utils.First;
import org.gradoop.flink.model.impl.layouts.gve.GVEBaseFactory;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class GVECollectionLayoutFactory
extends GVEBaseFactory
implements GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromDataSets(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices) {
        return this.fromDataSets(graphHeads, vertices, this.createEdgeDataSet(new ArrayList<EPGMEdge>(0)));
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromDataSets(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        return this.create(graphHeads, vertices, edges);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromIndexedDataSets(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        return this.create(graphHeads, vertices, edges);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromCollections(Collection<EPGMGraphHead> graphHeads, Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        return this.fromDataSets(this.createGraphHeadDataSet(Objects.requireNonNull(graphHeads, "EPGMGraphHead collection was null")), this.createVertexDataSet(Objects.requireNonNull(vertices, "EPGMVertex collection was null")), this.createEdgeDataSet(Objects.requireNonNull(edges, "EPGMEdge collection was null")));
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromGraphLayout(LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> graph) {
        return this.fromDataSets(graph.getGraphHead(), (DataSet<EPGMVertex>)graph.getVertices(), (DataSet<EPGMEdge>)graph.getEdges());
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromTransactions(DataSet<GraphTransaction> transactions) {
        First<EPGMVertex> vertexReducer = new First<EPGMVertex>();
        First<EPGMEdge> edgeReducer = new First<EPGMEdge>();
        return this.fromTransactions(transactions, (GroupReduceFunction<EPGMVertex, EPGMVertex>)vertexReducer, (GroupReduceFunction<EPGMEdge, EPGMEdge>)edgeReducer);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromTransactions(DataSet<GraphTransaction> transactions, GroupReduceFunction<EPGMVertex, EPGMVertex> vertexMergeReducer, GroupReduceFunction<EPGMEdge, EPGMEdge> edgeMergeReducer) {
        MapOperator graphHeads = transactions.map(new TransactionGraphHead());
        GroupReduceOperator vertices = transactions.flatMap(new TransactionVertices()).groupBy(new Id()).reduceGroup(vertexMergeReducer);
        GroupReduceOperator edges = transactions.flatMap(new TransactionEdges()).groupBy(new Id()).reduceGroup(edgeMergeReducer);
        return this.fromDataSets((DataSet<EPGMGraphHead>)graphHeads, (DataSet<EPGMVertex>)vertices, (DataSet<EPGMEdge>)edges);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> createEmptyCollection() {
        ArrayList<EPGMGraphHead> graphHeads = new ArrayList<EPGMGraphHead>();
        ArrayList<EPGMVertex> vertices = new ArrayList<EPGMVertex>();
        ArrayList<EPGMEdge> edges = new ArrayList<EPGMEdge>();
        return this.fromCollections((Collection<EPGMGraphHead>)graphHeads, (Collection<EPGMVertex>)vertices, (Collection<EPGMEdge>)edges);
    }
}

