/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.gve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayoutFactory;
import org.gradoop.flink.model.impl.functions.graphcontainment.AddToGraph;
import org.gradoop.flink.model.impl.layouts.gve.GVEBaseFactory;
import org.gradoop.flink.model.impl.layouts.gve.GVELayout;

public class GVEGraphLayoutFactory
extends GVEBaseFactory
implements LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    public GVELayout fromDataSets(DataSet<EPGMVertex> vertices) {
        return this.fromDataSets((DataSet)vertices, (DataSet)this.createEdgeDataSet(Lists.newArrayListWithCapacity((int)0)));
    }

    public GVELayout fromDataSets(DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        Objects.requireNonNull(vertices, "EPGMVertex DataSet was null");
        Objects.requireNonNull(edges, "EPGMEdge DataSet was null");
        EPGMGraphHead graphHead = (EPGMGraphHead)this.getGraphHeadFactory().createGraphHead();
        DataSource graphHeadSet = this.getConfig().getExecutionEnvironment().fromElements((Object[])new EPGMGraphHead[]{graphHead});
        vertices = vertices.map(new AddToGraph((GraphHead)graphHead)).withForwardedFields(new String[]{"id;label;properties"});
        edges = edges.map(new AddToGraph((GraphHead)graphHead)).withForwardedFields(new String[]{"id;sourceId;targetId;label;properties"});
        return new GVELayout((DataSet<EPGMGraphHead>)graphHeadSet, (DataSet<EPGMVertex>)vertices, (DataSet<EPGMEdge>)edges);
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromDataSets(DataSet<EPGMGraphHead> graphHead, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        return this.create(graphHead, vertices, edges);
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromIndexedDataSets(Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        EPGMGraphHead graphHead = (EPGMGraphHead)this.getGraphHeadFactory().createGraphHead();
        DataSource graphHeadSet = this.getConfig().getExecutionEnvironment().fromElements((Object[])new EPGMGraphHead[]{graphHead});
        HashMap graphHeads = Maps.newHashMap();
        graphHeads.put(graphHead.getLabel(), graphHeadSet);
        vertices = vertices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (MapOperator)((DataSet)e.getValue()).map(new AddToGraph((GraphHead)graphHead)).withForwardedFields(new String[]{"id;label;properties"})));
        edges = edges.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (MapOperator)((DataSet)e.getValue()).map(new AddToGraph((GraphHead)graphHead)).withForwardedFields(new String[]{"id;sourceId;targetId;label;properties"})));
        return this.create(graphHeads, vertices, edges);
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromIndexedDataSets(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        return this.create(graphHeads, vertices, edges);
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromCollections(EPGMGraphHead graphHead, Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        Objects.requireNonNull(vertices, "EPGMVertex collection was null");
        ArrayList graphHeads = graphHead == null ? Lists.newArrayListWithCapacity((int)0) : Lists.newArrayList((Object[])new EPGMGraphHead[]{graphHead});
        if (edges == null) {
            edges = Lists.newArrayListWithCapacity((int)0);
        }
        return this.fromDataSets(this.createGraphHeadDataSet(graphHeads), this.createVertexDataSet(vertices), this.createEdgeDataSet(edges));
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromCollections(Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        Objects.requireNonNull(vertices, "EPGMVertex collection was null");
        Objects.requireNonNull(edges, "EPGMEdge collection was null");
        return this.fromDataSets((DataSet)this.createVertexDataSet(vertices), (DataSet)this.createEdgeDataSet(edges));
    }

    @Override
    public LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> createEmptyGraph() {
        ArrayList<EPGMVertex> vertices = new ArrayList<EPGMVertex>(0);
        ArrayList<EPGMEdge> edges = new ArrayList<EPGMEdge>(0);
        return this.fromCollections((EPGMGraphHead)null, (Collection<EPGMVertex>)vertices, (Collection<EPGMEdge>)edges);
    }
}

