/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.gve;

import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphElement;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.impl.functions.epgm.ByLabel;
import org.gradoop.flink.model.impl.functions.epgm.GraphElementExpander;
import org.gradoop.flink.model.impl.functions.epgm.GraphVerticesEdges;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.TransactionFromSets;
import org.gradoop.flink.model.impl.functions.utils.Cast;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class GVELayout
implements LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge>,
GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    private final DataSet<EPGMGraphHead> graphHeads;
    private final DataSet<EPGMVertex> vertices;
    private final DataSet<EPGMEdge> edges;

    protected GVELayout(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices, DataSet<EPGMEdge> edges) {
        this.graphHeads = graphHeads;
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    public boolean isGVELayout() {
        return true;
    }

    @Override
    public boolean isIndexedGVELayout() {
        return false;
    }

    @Override
    public boolean isTransactionalLayout() {
        return false;
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHeads() {
        return this.graphHeads;
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHeadsByLabel(String label) {
        return this.graphHeads.filter(new ByLabel(label));
    }

    @Override
    public DataSet<GraphTransaction> getGraphTransactions() {
        FlatMapOperator graphVertexTuples = ((MapOperator)this.getVertices().map(new Cast(EPGMGraphElement.class)).returns(TypeExtractor.getForClass(EPGMGraphElement.class))).flatMap(new GraphElementExpander());
        FlatMapOperator graphEdgeTuples = ((MapOperator)this.getEdges().map(new Cast(EPGMGraphElement.class)).returns(TypeExtractor.getForClass(EPGMGraphElement.class))).flatMap(new GraphElementExpander());
        GroupReduceOperator transactions = graphVertexTuples.union((DataSet)graphEdgeTuples).groupBy(new int[]{0}).combineGroup((GroupCombineFunction)new GraphVerticesEdges()).groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new GraphVerticesEdges());
        return this.getGraphHeads().leftOuterJoin((DataSet)transactions).where(new Id()).equalTo(new int[]{0}).with((JoinFunction)new TransactionFromSets());
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHead() {
        return this.graphHeads;
    }

    @Override
    public DataSet<EPGMVertex> getVertices() {
        return this.vertices;
    }

    @Override
    public DataSet<EPGMVertex> getVerticesByLabel(String label) {
        return this.vertices.filter(new ByLabel(label));
    }

    @Override
    public DataSet<EPGMEdge> getEdges() {
        return this.edges;
    }

    @Override
    public DataSet<EPGMEdge> getEdgesByLabel(String label) {
        return this.edges.filter(new ByLabel(label));
    }
}

