/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.gve.indexed;

import java.util.Map;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.impl.layouts.gve.GVELayout;

public class IndexedGVELayout
extends GVELayout
implements LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge>,
GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    private final Map<String, DataSet<EPGMGraphHead>> graphHeads;
    private final Map<String, DataSet<EPGMVertex>> vertices;
    private final Map<String, DataSet<EPGMEdge>> edges;

    IndexedGVELayout(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        super(graphHeads.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during graph head union")), vertices.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during vertex union")), edges.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during edge union")));
        this.graphHeads = graphHeads;
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    public boolean isIndexedGVELayout() {
        return true;
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHeadsByLabel(String label) {
        return this.graphHeads.get(label);
    }

    @Override
    public DataSet<EPGMVertex> getVerticesByLabel(String label) {
        return this.vertices.get(label);
    }

    @Override
    public DataSet<EPGMEdge> getEdgesByLabel(String label) {
        return this.edges.get(label);
    }
}

