/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.transactional;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.util.GradoopConstants;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.impl.functions.epgm.ByDifferentGraphId;
import org.gradoop.flink.model.impl.functions.epgm.ByDifferentId;
import org.gradoop.flink.model.impl.functions.epgm.ByLabel;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.TransactionEdges;
import org.gradoop.flink.model.impl.functions.epgm.TransactionGraphHead;
import org.gradoop.flink.model.impl.functions.epgm.TransactionVertices;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class TxCollectionLayout
implements GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    private final DataSet<GraphTransaction> transactions;

    TxCollectionLayout(DataSet<GraphTransaction> transactions) {
        this.transactions = transactions;
    }

    @Override
    public boolean isGVELayout() {
        return false;
    }

    @Override
    public boolean isIndexedGVELayout() {
        return false;
    }

    @Override
    public boolean isTransactionalLayout() {
        return true;
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHeads() {
        return this.transactions.map(new TransactionGraphHead()).filter(new ByDifferentId(GradoopConstants.DB_GRAPH_ID));
    }

    @Override
    public DataSet<EPGMGraphHead> getGraphHeadsByLabel(String label) {
        return this.getGraphHeads().filter(new ByLabel(label));
    }

    @Override
    public DataSet<GraphTransaction> getGraphTransactions() {
        return this.transactions.filter((FilterFunction)new ByDifferentGraphId(GradoopConstants.DB_GRAPH_ID));
    }

    @Override
    public DataSet<EPGMVertex> getVertices() {
        return this.transactions.flatMap(new TransactionVertices()).distinct(new Id());
    }

    @Override
    public DataSet<EPGMVertex> getVerticesByLabel(String label) {
        return this.getVertices().filter(new ByLabel(label));
    }

    @Override
    public DataSet<EPGMEdge> getEdges() {
        return this.transactions.flatMap(new TransactionEdges()).distinct(new Id());
    }

    @Override
    public DataSet<EPGMEdge> getEdgesByLabel(String label) {
        return this.getEdges().filter(new ByLabel(label));
    }
}

