/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.layouts.transactional;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphElement;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.util.GradoopConstants;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayout;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayoutFactory;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayout;
import org.gradoop.flink.model.impl.functions.bool.False;
import org.gradoop.flink.model.impl.functions.epgm.GraphElementExpander;
import org.gradoop.flink.model.impl.functions.epgm.GraphVerticesEdges;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.TransactionFromSets;
import org.gradoop.flink.model.impl.functions.utils.Cast;
import org.gradoop.flink.model.impl.layouts.common.BaseFactory;
import org.gradoop.flink.model.impl.layouts.transactional.TxCollectionLayout;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class TxCollectionLayoutFactory
extends BaseFactory
implements GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromDataSets(DataSet<EPGMGraphHead> graphHeads, DataSet<EPGMVertex> vertices) {
        Objects.requireNonNull(graphHeads);
        Objects.requireNonNull(vertices);
        return this.fromDataSets(graphHeads, vertices, this.createEdgeDataSet(Lists.newArrayListWithCapacity((int)0)));
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromDataSets(DataSet<EPGMGraphHead> inGraphHeads, DataSet<EPGMVertex> inVertices, DataSet<EPGMEdge> inEdges) {
        Objects.requireNonNull(inGraphHeads);
        Objects.requireNonNull(inVertices);
        Objects.requireNonNull(inEdges);
        DataSource dbGraphHead = this.getConfig().getExecutionEnvironment().fromElements((Object[])new EPGMGraphHead[]{(EPGMGraphHead)this.getGraphHeadFactory().initGraphHead(GradoopConstants.DB_GRAPH_ID, "_DB")});
        inGraphHeads = inGraphHeads.union((DataSet)dbGraphHead);
        FlatMapOperator vertices = ((MapOperator)inVertices.map(new Cast(EPGMGraphElement.class)).returns(TypeExtractor.getForClass(EPGMGraphElement.class))).flatMap(new GraphElementExpander());
        FlatMapOperator edges = ((MapOperator)inEdges.map(new Cast(EPGMGraphElement.class)).returns(TypeExtractor.getForClass(EPGMGraphElement.class))).flatMap(new GraphElementExpander());
        GroupReduceOperator transactions = vertices.union((DataSet)edges).groupBy(new int[]{0}).combineGroup((GroupCombineFunction)new GraphVerticesEdges()).groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new GraphVerticesEdges());
        JoinOperator graphTransactions = inGraphHeads.leftOuterJoin((DataSet)transactions).where(new Id()).equalTo(new int[]{0}).with((JoinFunction)new TransactionFromSets());
        return new TxCollectionLayout((DataSet<GraphTransaction>)graphTransactions);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromIndexedDataSets(Map<String, DataSet<EPGMGraphHead>> graphHeads, Map<String, DataSet<EPGMVertex>> vertices, Map<String, DataSet<EPGMEdge>> edges) {
        Objects.requireNonNull(graphHeads);
        Objects.requireNonNull(vertices);
        Objects.requireNonNull(edges);
        return this.fromDataSets(graphHeads.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during graph head union")), vertices.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during vertex union")), edges.values().stream().reduce(DataSet::union).orElseThrow(() -> new RuntimeException("Error during edge union")));
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromCollections(Collection<EPGMGraphHead> graphHeads, Collection<EPGMVertex> vertices, Collection<EPGMEdge> edges) {
        return this.fromDataSets(this.createGraphHeadDataSet(graphHeads), this.createVertexDataSet(vertices), this.createEdgeDataSet(edges));
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromGraphLayout(LogicalGraphLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> logicalGraphLayout) {
        return this.fromDataSets(logicalGraphLayout.getGraphHead(), (DataSet<EPGMVertex>)logicalGraphLayout.getVertices(), (DataSet<EPGMEdge>)logicalGraphLayout.getEdges());
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromTransactions(DataSet<GraphTransaction> transactions) {
        return new TxCollectionLayout(transactions);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> fromTransactions(DataSet<GraphTransaction> transactions, GroupReduceFunction<EPGMVertex, EPGMVertex> vertexMergeReducer, GroupReduceFunction<EPGMEdge, EPGMEdge> edgeMergeReducer) {
        return new TxCollectionLayout(transactions);
    }

    @Override
    public GraphCollectionLayout<EPGMGraphHead, EPGMVertex, EPGMEdge> createEmptyCollection() {
        return this.fromTransactions(this.createGraphTransactionDataSet(Lists.newArrayListWithCapacity((int)0)));
    }

    private DataSet<GraphTransaction> createGraphTransactionDataSet(Collection<GraphTransaction> transactions) {
        ExecutionEnvironment env = this.getConfig().getExecutionEnvironment();
        Object graphTransactionSet = transactions.isEmpty() ? env.fromCollection((Collection)Lists.newArrayList((Object[])new GraphTransaction[]{new GraphTransaction()}), new TypeHint<GraphTransaction>(){}.getTypeInfo()).filter(new False()) : env.fromCollection(transactions);
        return graphTransactionSet;
    }
}

