/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.operators.ApplicableUnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.functions.epgm.ElementsOfSelectedGraphs;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateTransactions;
import org.gradoop.flink.model.impl.operators.aggregation.functions.ApplyAggregateElements;
import org.gradoop.flink.model.impl.operators.aggregation.functions.CombinePartitionApplyAggregates;
import org.gradoop.flink.model.impl.operators.aggregation.functions.SetAggregateProperties;

public class ApplyAggregation<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements ApplicableUnaryBaseGraphToBaseGraphOperator<GC> {
    private final Set<AggregateFunction> aggregateFunctions;

    public ApplyAggregation(AggregateFunction ... aggregateFunctions) {
        for (AggregateFunction aggFunc : aggregateFunctions) {
            Preconditions.checkNotNull((Object)aggFunc);
        }
        this.aggregateFunctions = new HashSet<AggregateFunction>(Arrays.asList(aggregateFunctions));
    }

    @Override
    public GC executeForGVELayout(GC collection) {
        CoGroupOperator graphHeads = collection.getGraphHeads();
        MapOperator graphIds = graphHeads.map(new Id());
        GroupReduceOperator aggregate = this.aggregateVertices(collection.getVertices(), (DataSet<GradoopId>)graphIds).union(this.aggregateEdges(collection.getEdges(), (DataSet<GradoopId>)graphIds)).groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new CombinePartitionApplyAggregates(this.aggregateFunctions));
        graphHeads = graphHeads.coGroup((DataSet)aggregate).where(new Id()).equalTo(new int[]{0}).with(new SetAggregateProperties(this.aggregateFunctions));
        return collection.getFactory().fromDataSets(graphHeads, collection.getVertices(), collection.getEdges());
    }

    @Override
    public GC executeForTxLayout(GC collection) {
        MapOperator updatedTransactions = collection.getGraphTransactions().map((MapFunction)new AggregateTransactions(this.aggregateFunctions));
        return collection.getFactory().fromTransactions((DataSet<GraphTransaction>)updatedTransactions);
    }

    private DataSet<Tuple2<GradoopId, Map<String, PropertyValue>>> aggregateVertices(DataSet<V> vertices, DataSet<GradoopId> graphIds) {
        return ((FlatMapOperator)vertices.flatMap(new ElementsOfSelectedGraphs()).withBroadcastSet(graphIds, "graphIds")).groupBy(new int[]{0}).combineGroup(new ApplyAggregateElements(this.aggregateFunctions.stream().filter(AggregateFunction::isVertexAggregation).collect(Collectors.toSet())));
    }

    private DataSet<Tuple2<GradoopId, Map<String, PropertyValue>>> aggregateEdges(DataSet<E> edges, DataSet<GradoopId> graphIds) {
        return ((FlatMapOperator)edges.flatMap(new ElementsOfSelectedGraphs()).withBroadcastSet(graphIds, "graphIds")).groupBy(new int[]{0}).combineGroup(new ApplyAggregateElements(this.aggregateFunctions.stream().filter(AggregateFunction::isEdgeAggregation).collect(Collectors.toSet())));
    }
}

