/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

public class AggregateElements<T extends Element>
implements GroupCombineFunction<T, Map<String, PropertyValue>> {
    private final Set<AggregateFunction> aggregateFunctions;

    public AggregateElements(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = aggregateFunctions;
    }

    public void combine(Iterable<T> elements, Collector<Map<String, PropertyValue>> out) {
        Map<String, PropertyValue> aggregate = new HashMap<String, PropertyValue>();
        for (Element element : elements) {
            aggregate = AggregateUtil.increment(aggregate, element, this.aggregateFunctions);
        }
        if (!aggregate.isEmpty()) {
            out.collect(aggregate);
        }
    }
}

