/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

public class AggregateTransactions
implements MapFunction<GraphTransaction, GraphTransaction> {
    private final Set<AggregateFunction> aggregateFunctions;
    private final Set<AggregateFunction> vertexAggregateFunctions;
    private final Set<AggregateFunction> edgeAggregateFunctions;
    private final Map<String, PropertyValue> aggregateDefaultValues;

    public AggregateTransactions(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = aggregateFunctions;
        this.vertexAggregateFunctions = aggregateFunctions.stream().filter(AggregateFunction::isVertexAggregation).collect(Collectors.toSet());
        this.edgeAggregateFunctions = aggregateFunctions.stream().filter(AggregateFunction::isEdgeAggregation).collect(Collectors.toSet());
        this.aggregateDefaultValues = new HashMap<String, PropertyValue>();
        for (AggregateFunction func : aggregateFunctions) {
            this.aggregateDefaultValues.put(func.getAggregatePropertyKey(), AggregateUtil.getDefaultAggregate(func));
        }
    }

    public GraphTransaction map(GraphTransaction graphTransaction) throws Exception {
        Map<String, PropertyValue> aggregate = new HashMap<String, PropertyValue>();
        aggregate = this.aggregateVertices(aggregate, graphTransaction);
        aggregate = this.aggregateEdges(aggregate, graphTransaction);
        for (AggregateFunction function : this.aggregateFunctions) {
            aggregate.computeIfPresent(function.getAggregatePropertyKey(), (k, v) -> function.postAggregate((PropertyValue)v));
        }
        this.aggregateDefaultValues.forEach(aggregate::putIfAbsent);
        aggregate.forEach((arg_0, arg_1) -> ((EPGMGraphHead)graphTransaction.getGraphHead()).setProperty(arg_0, arg_1));
        return graphTransaction;
    }

    private Map<String, PropertyValue> aggregateVertices(Map<String, PropertyValue> aggregate, GraphTransaction graphTransaction) {
        for (EPGMVertex vertex : graphTransaction.getVertices()) {
            aggregate = AggregateUtil.increment(aggregate, (Element)vertex, this.vertexAggregateFunctions);
        }
        return aggregate;
    }

    private Map<String, PropertyValue> aggregateEdges(Map<String, PropertyValue> aggregate, GraphTransaction graphTransaction) {
        for (EPGMEdge edge : graphTransaction.getEdges()) {
            aggregate = AggregateUtil.increment(aggregate, (Element)edge, this.edgeAggregateFunctions);
        }
        return aggregate;
    }
}

