/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

public class ApplyAggregateElements<T extends Element>
implements GroupCombineFunction<Tuple2<GradoopId, T>, Tuple2<GradoopId, Map<String, PropertyValue>>> {
    private final Set<AggregateFunction> aggregateFunctions;
    private final Tuple2<GradoopId, Map<String, PropertyValue>> reusePair = new Tuple2();

    public ApplyAggregateElements(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = aggregateFunctions;
    }

    public void combine(Iterable<Tuple2<GradoopId, T>> elements, Collector<Tuple2<GradoopId, Map<String, PropertyValue>>> out) {
        Iterator<Tuple2<GradoopId, T>> iterator = elements.iterator();
        Tuple2<GradoopId, T> graphIdElement = iterator.next();
        Map<String, PropertyValue> aggregate = AggregateUtil.increment(new HashMap<String, PropertyValue>(), (Element)graphIdElement.f1, this.aggregateFunctions);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next().f1;
            aggregate = AggregateUtil.increment(aggregate, element, this.aggregateFunctions);
        }
        if (!aggregate.isEmpty()) {
            this.reusePair.f0 = graphIdElement.f0;
            this.reusePair.f1 = aggregate;
            out.collect(this.reusePair);
        }
    }
}

