/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;

public class CombinePartitionAggregates
implements GroupReduceFunction<Map<String, PropertyValue>, Map<String, PropertyValue>> {
    private final Set<AggregateFunction> aggregateFunctions;

    public CombinePartitionAggregates(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = aggregateFunctions;
    }

    public void reduce(Iterable<Map<String, PropertyValue>> partitionAggregates, Collector<Map<String, PropertyValue>> out) throws Exception {
        Iterator<Map<String, PropertyValue>> iterator = partitionAggregates.iterator();
        Map<String, PropertyValue> aggregate = iterator.next();
        while (iterator.hasNext()) {
            Map<String, PropertyValue> next = iterator.next();
            for (AggregateFunction aggFunc : this.aggregateFunctions) {
                String propertyKey = aggFunc.getAggregatePropertyKey();
                PropertyValue nextAgg = next.get(propertyKey);
                if (nextAgg == null) continue;
                aggregate.compute(propertyKey, (key, agg) -> agg == null ? nextAgg : aggFunc.aggregate((PropertyValue)agg, nextAgg));
            }
        }
        out.collect(aggregate);
    }
}

