/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;

public class CombinePartitionApplyAggregates
implements GroupReduceFunction<Tuple2<GradoopId, Map<String, PropertyValue>>, Tuple2<GradoopId, Map<String, PropertyValue>>> {
    private final Set<AggregateFunction> aggregateFunctions;

    public CombinePartitionApplyAggregates(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = aggregateFunctions;
    }

    public void reduce(Iterable<Tuple2<GradoopId, Map<String, PropertyValue>>> values, Collector<Tuple2<GradoopId, Map<String, PropertyValue>>> out) throws Exception {
        Iterator<Tuple2<GradoopId, Map<String, PropertyValue>>> iterator = values.iterator();
        Tuple2<GradoopId, Map<String, PropertyValue>> aggregate = iterator.next();
        while (iterator.hasNext()) {
            Tuple2<GradoopId, Map<String, PropertyValue>> next = iterator.next();
            for (AggregateFunction aggFunc : this.aggregateFunctions) {
                String propertyKey = aggFunc.getAggregatePropertyKey();
                PropertyValue nextAgg = (PropertyValue)((Map)next.f1).get(propertyKey);
                if (nextAgg == null) continue;
                ((Map)aggregate.f1).compute(propertyKey, (key, agg) -> agg == null ? nextAgg : aggFunc.aggregate((PropertyValue)agg, nextAgg));
            }
        }
        out.collect(aggregate);
    }
}

