/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

public class SetAggregateProperties<G extends GraphHead>
implements CoGroupFunction<G, Tuple2<GradoopId, Map<String, PropertyValue>>, G> {
    private final Map<String, PropertyValue> defaultValues = new HashMap<String, PropertyValue>();
    private final Set<AggregateFunction> aggregateFunctions;

    public SetAggregateProperties(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = Objects.requireNonNull(aggregateFunctions);
        for (AggregateFunction func : aggregateFunctions) {
            Objects.requireNonNull(func);
            this.defaultValues.put(func.getAggregatePropertyKey(), AggregateUtil.getDefaultAggregate(func));
        }
    }

    public void coGroup(Iterable<G> left, Iterable<Tuple2<GradoopId, Map<String, PropertyValue>>> right, Collector<G> out) {
        for (GraphHead leftElem : left) {
            boolean rightEmpty = true;
            for (Tuple2<GradoopId, Map<String, PropertyValue>> rightElem : right) {
                Map values = (Map)rightElem.f1;
                for (AggregateFunction function : this.aggregateFunctions) {
                    values.computeIfPresent(function.getAggregatePropertyKey(), (k, v) -> function.postAggregate((PropertyValue)v));
                }
                values.forEach((arg_0, arg_1) -> ((GraphHead)leftElem).setProperty(arg_0, arg_1));
                out.collect((Object)leftElem);
                rightEmpty = false;
            }
            if (!rightEmpty) continue;
            this.defaultValues.forEach((arg_0, arg_1) -> ((GraphHead)leftElem).setProperty(arg_0, arg_1));
            out.collect((Object)leftElem);
        }
    }
}

