/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.impl.operators.aggregation.functions.AggregateUtil;

@FunctionAnnotation.ForwardedFields(value={"id"})
public class SetAggregateProperty<G extends GraphHead>
extends RichMapFunction<G, G> {
    public static final String VALUE = "value";
    private final Set<AggregateFunction> aggregateFunctions;
    private Map<String, PropertyValue> aggregateValues;
    private final Map<String, PropertyValue> defaultValues;

    public SetAggregateProperty(Set<AggregateFunction> aggregateFunctions) {
        this.aggregateFunctions = Objects.requireNonNull(aggregateFunctions);
        this.defaultValues = new HashMap<String, PropertyValue>();
        for (AggregateFunction func : aggregateFunctions) {
            Objects.requireNonNull(func);
            this.defaultValues.put(func.getAggregatePropertyKey(), AggregateUtil.getDefaultAggregate(func));
        }
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        if (this.getRuntimeContext().getBroadcastVariable(VALUE).isEmpty()) {
            this.aggregateValues = this.defaultValues;
        } else {
            this.aggregateValues = (Map)this.getRuntimeContext().getBroadcastVariable(VALUE).get(0);
            for (AggregateFunction function : this.aggregateFunctions) {
                this.aggregateValues.computeIfPresent(function.getAggregatePropertyKey(), (k, v) -> function.postAggregate((PropertyValue)v));
            }
            this.defaultValues.forEach(this.aggregateValues::putIfAbsent);
        }
    }

    public G map(G graphHead) throws Exception {
        this.aggregateValues.forEach((arg_0, arg_1) -> graphHead.setProperty(arg_0, arg_1));
        return graphHead;
    }
}

