/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.aggregation.functions.average;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.PropertyValueUtils;
import org.gradoop.flink.model.api.functions.AggregateFunction;

public interface Average
extends AggregateFunction {
    public static final PropertyValue IGNORED_VALUE = PropertyValue.create(Arrays.asList(PropertyValue.create((Object)0L), PropertyValue.create((Object)0L)));

    @Override
    default public PropertyValue aggregate(PropertyValue aggregate, PropertyValue increment) {
        List aggregateValue = aggregate.getList();
        List incrementValue = increment.getList();
        PropertyValue sum = PropertyValueUtils.Numeric.add((PropertyValue)((PropertyValue)aggregateValue.get(0)), (PropertyValue)((PropertyValue)incrementValue.get(0)));
        PropertyValue count = PropertyValueUtils.Numeric.add((PropertyValue)((PropertyValue)aggregateValue.get(1)), (PropertyValue)((PropertyValue)incrementValue.get(1)));
        aggregateValue.set(0, sum);
        aggregateValue.set(1, count);
        aggregate.setList(aggregateValue);
        return aggregate;
    }

    @Override
    default public PropertyValue postAggregate(PropertyValue result) {
        if (!Objects.requireNonNull(result).isList()) {
            throw new IllegalArgumentException("The aggregate value is expected to be a List.");
        }
        List value = result.getList();
        if (value.size() != 2) {
            throw new IllegalArgumentException("The aggregate value list is expected to have size 2.");
        }
        if (!((PropertyValue)value.get(0)).isNumber() || !((PropertyValue)value.get(1)).isLong()) {
            throw new IllegalArgumentException("The aggregate value list contains unsupported types.");
        }
        double sum = ((Number)((PropertyValue)value.get(0)).getObject()).doubleValue();
        long count = ((PropertyValue)value.get(1)).getLong();
        if (count < 0L) {
            throw new IllegalArgumentException("Invalid number of elements " + count + ", expected value greater than zero.");
        }
        if (count == 0L) {
            return PropertyValue.NULL_VALUE;
        }
        result.setDouble(sum / (double)count);
        return result;
    }
}

