/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.base;

import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphCollectionToBaseGraphCollectionOperator;

public abstract class BinaryCollectionToCollectionOperatorBase<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements BinaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> {
    protected GC firstCollection;
    protected GC secondCollection;

    @Override
    public GC execute(GC firstCollection, GC secondCollection) {
        this.firstCollection = firstCollection;
        this.secondCollection = secondCollection;
        DataSet<G> newGraphHeads = this.computeNewGraphHeads();
        DataSet<V> newVertices = this.computeNewVertices(newGraphHeads);
        DataSet<E> newEdges = this.computeNewEdges(newVertices);
        return firstCollection.getFactory().fromDataSets(newGraphHeads, newVertices, newEdges);
    }

    protected abstract DataSet<V> computeNewVertices(DataSet<G> var1);

    protected abstract DataSet<G> computeNewGraphHeads();

    protected abstract DataSet<E> computeNewEdges(DataSet<V> var1);
}

