/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.cloning;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.functions.epgm.Clone;
import org.gradoop.flink.model.impl.functions.epgm.ElementIdUpdater;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.PairElementWithNewId;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.operators.cloning.functions.EdgeSourceUpdateJoin;
import org.gradoop.flink.model.impl.operators.cloning.functions.EdgeTargetUpdateJoin;
import org.gradoop.flink.model.impl.operators.cloning.functions.ElementGraphUpdater;
import org.gradoop.flink.model.impl.operators.cloning.functions.Value0Of2ToId;

public class Cloning<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphToBaseGraphOperator<LG> {
    @Override
    public LG execute(LG graph) {
        MapOperator graphHead = graph.getGraphHead().map(new Clone());
        MapOperator graphId = graphHead.map(new Id());
        MapOperator vertexTuple = graph.getVertices().map(new PairElementWithNewId());
        MapOperator vertexIdTuple = vertexTuple.map(new Value0Of2ToId());
        SingleInputUdfOperator vertices = vertexTuple.map(new ElementIdUpdater()).map(new ElementGraphUpdater()).withBroadcastSet((DataSet)graphId, "graph id");
        SingleInputUdfOperator edges = graph.getEdges().map(new Clone()).join((DataSet)vertexIdTuple).where(new SourceId()).equalTo(new int[]{0}).with(new EdgeSourceUpdateJoin()).join((DataSet)vertexIdTuple).where(new TargetId()).equalTo(new int[]{0}).with(new EdgeTargetUpdateJoin()).map(new ElementGraphUpdater()).withBroadcastSet((DataSet)graphId, "graph id");
        return graph.getFactory().fromDataSets(graphHead, vertices, edges);
    }
}

