/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.equality;

import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.BinaryBaseGraphCollectionToValueOperator;
import org.gradoop.flink.model.impl.functions.bool.Equals;
import org.gradoop.flink.model.impl.operators.tostring.CanonicalAdjacencyMatrixBuilder;
import org.gradoop.flink.model.impl.operators.tostring.api.EdgeToString;
import org.gradoop.flink.model.impl.operators.tostring.api.GraphHeadToString;
import org.gradoop.flink.model.impl.operators.tostring.api.VertexToString;

public class CollectionEquality<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements BinaryBaseGraphCollectionToValueOperator<GC, DataSet<Boolean>> {
    private final CanonicalAdjacencyMatrixBuilder<G, V, E, LG, GC> canonicalAdjacencyMatrixBuilder;

    public CollectionEquality(GraphHeadToString<G> graphHeadToString, VertexToString<V> vertexToString, EdgeToString<E> edgeToString, boolean directed) {
        this.canonicalAdjacencyMatrixBuilder = new CanonicalAdjacencyMatrixBuilder(graphHeadToString, vertexToString, edgeToString, directed);
    }

    @Override
    public DataSet<Boolean> execute(GC firstCollection, GC secondCollection) {
        return Equals.cross(this.canonicalAdjacencyMatrixBuilder.execute(firstCollection), this.canonicalAdjacencyMatrixBuilder.execute(secondCollection));
    }
}

