/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.exclusion;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.ReducibleBinaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.functions.epgm.ByDifferentId;
import org.gradoop.flink.model.impl.functions.epgm.BySameId;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.graphcontainment.InGraph;
import org.gradoop.flink.model.impl.functions.graphcontainment.NotInGraphsBroadcast;

public class ReduceExclusion<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements ReducibleBinaryBaseGraphToBaseGraphOperator<GC, LG> {
    private final GradoopId startId;

    public ReduceExclusion(GradoopId startId) {
        this.startId = startId;
    }

    @Override
    public LG execute(GC collection) {
        MapOperator excludedGraphIds = collection.getGraphHeads().filter(new ByDifferentId(this.startId)).map(new Id());
        SingleInputUdfOperator vertices = collection.getVertices().filter(new InGraph(this.startId)).filter(new NotInGraphsBroadcast()).withBroadcastSet((DataSet)excludedGraphIds, "graphIds");
        SingleInputUdfOperator edges = collection.getEdges().filter(new InGraph(this.startId)).filter(new NotInGraphsBroadcast()).withBroadcastSet((DataSet)excludedGraphIds, "graphIds");
        return collection.getGraphFactory().fromDataSets(collection.getGraphHeads().filter(new BySameId(this.startId)), vertices, edges);
    }
}

